class OverseerHistoryDetailsBo {
  OverseerHistoryDetailsBo({
    this.data,
  });

  OverseerHistoryDetailsBo.fromJson(dynamic json) {
    if (json['data'] != null) {
      data = [];
      json['data'].forEach((v) {
        data?.add(DataHistoryDetails.fromJson(v));
      });
    }
  }

  List<DataHistoryDetails>? data;

  OverseerHistoryDetailsBo copyWith({
    List<DataHistoryDetails>? data,
  }) =>
      OverseerHistoryDetailsBo(
        data: data ?? this.data,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (data != null) {
      map['data'] = data?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}

class DataHistoryDetails {
  DataHistoryDetails({
    this.id,
    this.inspectors,
    this.user,
    this.examDate,
    this.pdNum,
    this.xzNum,
    this.type,
    this.positionType,
    this.setup,
    this.unit,
    this.adopt,
    this.score,
  });

  DataHistoryDetails.fromJson(dynamic json) {
    id = json['id'];
    inspectors = json['inspectors'] != null
        ? Inspectors.fromJson(json['inspectors'])
        : null;
    user = json['user'] != null ? User.fromJson(json['user']) : null;
    examDate = json['examDate'];
    pdNum = json['pdNum'];
    xzNum = json['xzNum'];
    type = json['type'] != null ? Type.fromJson(json['type']) : null;
    positionType = json['positionType'];
    setup = json['setup'];
    unit = json['unit'] != null ? Unit.fromJson(json['unit']) : null;
    adopt = json['adopt'];
    score = json['score'];
  }

  String? id;
  Inspectors? inspectors;
  User? user;
  String? examDate;
  num? pdNum;
  num? xzNum;
  Type? type;
  String? positionType;
  String? setup;
  Unit? unit;
  String? adopt;
  num? score;

  DataHistoryDetails copyWith({
    String? id,
    Inspectors? inspectors,
    User? user,
    String? examDate,
    num? pdNum,
    num? xzNum,
    Type? type,
    String? positionType,
    String? setup,
    Unit? unit,
    String? adopt,
    num? score,
  }) =>
      DataHistoryDetails(
        id: id ?? this.id,
        inspectors: inspectors ?? this.inspectors,
        user: user ?? this.user,
        examDate: examDate ?? this.examDate,
        pdNum: pdNum ?? this.pdNum,
        xzNum: xzNum ?? this.xzNum,
        type: type ?? this.type,
        positionType: positionType ?? this.positionType,
        setup: setup ?? this.setup,
        unit: unit ?? this.unit,
        adopt: adopt ?? this.adopt,
        score: score ?? this.score,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    if (inspectors != null) {
      map['inspectors'] = inspectors?.toJson();
    }
    if (user != null) {
      map['user'] = user?.toJson();
    }
    map['examDate'] = examDate;
    map['pdNum'] = pdNum;
    map['xzNum'] = xzNum;
    if (type != null) {
      map['type'] = type?.toJson();
    }
    map['positionType'] = positionType;
    map['setup'] = setup;
    if (unit != null) {
      map['unit'] = unit?.toJson();
    }
    map['adopt'] = adopt;
    map['score'] = score;
    return map;
  }
}

class Unit {
  Unit({
    this.id,
    this.name,
    this.sort,
    this.hasChildren,
    this.parentId,
  });

  Unit.fromJson(dynamic json) {
    id = json['id'];
    name = json['name'];
    sort = json['sort'];
    hasChildren = json['hasChildren'];
    parentId = json['parentId'];
  }

  String? id;
  String? name;
  num? sort;
  bool? hasChildren;
  String? parentId;

  Unit copyWith({
    String? id,
    String? name,
    num? sort,
    bool? hasChildren,
    String? parentId,
  }) =>
      Unit(
        id: id ?? this.id,
        name: name ?? this.name,
        sort: sort ?? this.sort,
        hasChildren: hasChildren ?? this.hasChildren,
        parentId: parentId ?? this.parentId,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['name'] = name;
    map['sort'] = sort;
    map['hasChildren'] = hasChildren;
    map['parentId'] = parentId;
    return map;
  }
}

class Type {
  Type({
    this.id,
    this.name,
  });

  Type.fromJson(dynamic json) {
    id = json['id'];
    name = json['name'];
  }

  String? id;
  String? name;

  Type copyWith({
    String? id,
    String? name,
  }) =>
      Type(
        id: id ?? this.id,
        name: name ?? this.name,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['name'] = name;
    return map;
  }
}

class User {
  User({
    this.id,
    this.name,
    this.loginFlag,
    this.admin,
    this.roleNames,
  });

  User.fromJson(dynamic json) {
    id = json['id'];
    name = json['name'];
    loginFlag = json['loginFlag'];
    admin = json['admin'];
    roleNames = json['roleNames'];
  }

  String? id;
  String? name;
  String? loginFlag;
  bool? admin;
  String? roleNames;

  User copyWith({
    String? id,
    String? name,
    String? loginFlag,
    bool? admin,
    String? roleNames,
  }) =>
      User(
        id: id ?? this.id,
        name: name ?? this.name,
        loginFlag: loginFlag ?? this.loginFlag,
        admin: admin ?? this.admin,
        roleNames: roleNames ?? this.roleNames,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['name'] = name;
    map['loginFlag'] = loginFlag;
    map['admin'] = admin;
    map['roleNames'] = roleNames;
    return map;
  }
}

class Inspectors {
  Inspectors({
    this.id,
    this.name,
    this.loginFlag,
    this.admin,
    this.roleNames,
  });

  Inspectors.fromJson(dynamic json) {
    id = json['id'];
    name = json['name'];
    loginFlag = json['loginFlag'];
    admin = json['admin'];
    roleNames = json['roleNames'];
  }

  String? id;
  String? name;
  String? loginFlag;
  bool? admin;
  String? roleNames;

  Inspectors copyWith({
    String? id,
    String? name,
    String? loginFlag,
    bool? admin,
    String? roleNames,
  }) =>
      Inspectors(
        id: id ?? this.id,
        name: name ?? this.name,
        loginFlag: loginFlag ?? this.loginFlag,
        admin: admin ?? this.admin,
        roleNames: roleNames ?? this.roleNames,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['name'] = name;
    map['loginFlag'] = loginFlag;
    map['admin'] = admin;
    map['roleNames'] = roleNames;
    return map;
  }
}
