class ExamineQuestionsBo {
  ExamineQuestionsBo({
    this.data,
  });

  ExamineQuestionsBo.fromJson(dynamic json) {
    data = json['data'] != null ? Data.fromJson(json['data']) : null;
  }

  Data? data;

  ExamineQuestionsBo copyWith({
    Data? data,
  }) =>
      ExamineQuestionsBo(
        data: data ?? this.data,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (data != null) {
      map['data'] = data?.toJson();
    }
    return map;
  }
}

class Data {
  Data({
    this.id,
    this.createDate,
    this.updateDate,
    this.name,
    this.questionint,
    this.user,
    this.inspectors,
    this.adopt,
    this.unit,
    this.examDate,
    this.type,
    this.dxint,
    this.pdint,
    this.examQuestionList,
  });

  Data.fromJson(dynamic json) {
    id = json['id'];
    createDate = json['createDate'];
    updateDate = json['updateDate'];
    name = json['name'];
    questionint = json['questionint'];
    user = json['user'] != null ? User.fromJson(json['user']) : null;
    inspectors = json['inspectors'] != null
        ? Inspectors.fromJson(json['inspectors'])
        : null;
    adopt = json['adopt'];
    unit = json['unit'] != null ? Unit.fromJson(json['unit']) : null;
    examDate = json['examDate'];
    type = json['type'] != null ? Type.fromJson(json['type']) : null;
    dxint = json['dxint'];
    pdint = json['pdint'];
    if (json['examQuestionList'] != null) {
      examQuestionList = [];
      json['examQuestionList'].forEach((v) {
        examQuestionList?.add(ExamQuestionList.fromJson(v));
      });
    }
  }

  String? id;
  String? createDate;
  String? updateDate;
  String? name;
  int? questionint;
  User? user;
  Inspectors? inspectors;
  String? adopt;
  Unit? unit;
  int? examDate;
  Type? type;
  int? dxint;
  int? pdint;
  List<ExamQuestionList>? examQuestionList;

  Data copyWith({
    String? id,
    String? createDate,
    String? updateDate,
    String? name,
    int? questionint,
    User? user,
    Inspectors? inspectors,
    String? adopt,
    Unit? unit,
    int? examDate,
    Type? type,
    int? dxint,
    int? pdint,
    List<ExamQuestionList>? examQuestionList,
  }) =>
      Data(
        id: id ?? this.id,
        createDate: createDate ?? this.createDate,
        updateDate: updateDate ?? this.updateDate,
        name: name ?? this.name,
        questionint: questionint ?? this.questionint,
        user: user ?? this.user,
        inspectors: inspectors ?? this.inspectors,
        adopt: adopt ?? this.adopt,
        unit: unit ?? this.unit,
        examDate: examDate ?? this.examDate,
        type: type ?? this.type,
        dxint: dxint ?? this.dxint,
        pdint: pdint ?? this.pdint,
        examQuestionList: examQuestionList ?? this.examQuestionList,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['createDate'] = createDate;
    map['updateDate'] = updateDate;
    map['name'] = name;
    map['questionint'] = questionint;
    if (user != null) {
      map['user'] = user?.toJson();
    }
    if (inspectors != null) {
      map['inspectors'] = inspectors?.toJson();
    }
    map['adopt'] = adopt;
    if (unit != null) {
      map['unit'] = unit?.toJson();
    }
    map['examDate'] = examDate;
    if (type != null) {
      map['type'] = type?.toJson();
    }
    map['dxint'] = dxint;
    map['pdint'] = pdint;
    if (examQuestionList != null) {
      map['examQuestionList'] =
          examQuestionList?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}

class ExamQuestionList {
  ExamQuestionList({
    this.id,
    this.content,
    this.answer,
    this.type,
    this.questionType,
    this.detailId,
    this.sort,
    this.examQuestionOptionList,
    this.result,
  });

  ExamQuestionList.fromJson(dynamic json) {
    id = json['id'];
    content = json['content'];
    answer = json['answer'];
    type = json['type'];
    questionType = json['questionType'];
    detailId = json['detailId'];
    sort = json['sort'];
    if (json['examQuestionOptionList'] != null) {
      examQuestionOptionList = [];
      json['examQuestionOptionList'].forEach((v) {
        examQuestionOptionList?.add(ExamQuestionOptionList.fromJson(v));
      });
    }
    result = json['result'];
  }

  String? id;
  String? content;
  String? answer;
  String? type;
  String? questionType;
  String? detailId;
  int? sort;
  List<ExamQuestionOptionList>? examQuestionOptionList;
  String? result = '';

  ExamQuestionList copyWith({
    String? id,
    String? content,
    String? answer,
    String? type,
    String? questionType,
    String? detailId,
    int? sort,
    List<ExamQuestionOptionList>? examQuestionOptionList,
    String? result,
  }) =>
      ExamQuestionList(
        id: id ?? this.id,
        content: content ?? this.content,
        answer: answer ?? this.answer,
        type: type ?? this.type,
        questionType: questionType ?? this.questionType,
        detailId: detailId ?? this.detailId,
        sort: sort ?? this.sort,
        examQuestionOptionList:
            examQuestionOptionList ?? this.examQuestionOptionList,
        result: result ?? this.result,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['content'] = content;
    map['answer'] = answer;
    map['type'] = type;
    map['questionType'] = questionType;
    map['detailId'] = detailId;
    map['sort'] = sort;
    if (examQuestionOptionList != null) {
      map['examQuestionOptionList'] =
          examQuestionOptionList?.map((v) => v.toJson()).toList();
    }
    map['result'] = result;
    return map;
  }
}

class ExamQuestionOptionList {
  ExamQuestionOptionList({
    this.id,
    this.content,
    this.options,
    this.question,
  });

  ExamQuestionOptionList.fromJson(dynamic json) {
    id = json['id'];
    content = json['content'];
    options = json['options'];
    question =
        json['question'] != null ? Question.fromJson(json['question']) : null;
  }

  String? id;
  String? content;
  String? options;
  Question? question;
  bool? isSelected = false;

  ///隐藏式答案
  bool? isAcquiesceSelected = false;

  ExamQuestionOptionList copyWith({
    String? id,
    String? content,
    String? options,
    Question? question,
  }) =>
      ExamQuestionOptionList(
        id: id ?? this.id,
        content: content ?? this.content,
        options: options ?? this.options,
        question: question ?? this.question,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['content'] = content;
    map['options'] = options;
    if (question != null) {
      map['question'] = question?.toJson();
    }
    return map;
  }
}

class Question {
  Question({
    this.id,
  });

  Question.fromJson(dynamic json) {
    id = json['id'];
  }

  String? id;

  Question copyWith({
    String? id,
  }) =>
      Question(
        id: id ?? this.id,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    return map;
  }
}

class Type {
  Type({
    this.id,
  });

  Type.fromJson(dynamic json) {
    id = json['id'];
  }

  String? id;

  Type copyWith({
    String? id,
  }) =>
      Type(
        id: id ?? this.id,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    return map;
  }
}

class Unit {
  Unit({
    this.id,
    this.parentIds,
    this.name,
    this.sort,
    this.hasChildren,
    this.type,
    this.parentId,
  });

  Unit.fromJson(dynamic json) {
    id = json['id'];
    parentIds = json['parentIds'];
    name = json['name'];
    sort = json['sort'];
    hasChildren = json['hasChildren'];
    type = json['type'];
    parentId = json['parentId'];
  }

  String? id;
  String? parentIds;
  String? name;
  int? sort;
  bool? hasChildren;
  String? type;
  String? parentId;

  Unit copyWith({
    String? id,
    String? parentIds,
    String? name,
    int? sort,
    bool? hasChildren,
    String? type,
    String? parentId,
  }) =>
      Unit(
        id: id ?? this.id,
        parentIds: parentIds ?? this.parentIds,
        name: name ?? this.name,
        sort: sort ?? this.sort,
        hasChildren: hasChildren ?? this.hasChildren,
        type: type ?? this.type,
        parentId: parentId ?? this.parentId,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['parentIds'] = parentIds;
    map['name'] = name;
    map['sort'] = sort;
    map['hasChildren'] = hasChildren;
    map['type'] = type;
    map['parentId'] = parentId;
    return map;
  }
}

class Inspectors {
  Inspectors({
    this.id,
    this.loginFlag,
    this.admin,
    this.roleNames,
  });

  Inspectors.fromJson(dynamic json) {
    id = json['id'];
    loginFlag = json['loginFlag'];
    admin = json['admin'];
    roleNames = json['roleNames'];
  }

  String? id;
  String? loginFlag;
  bool? admin;
  String? roleNames;

  Inspectors copyWith({
    String? id,
    String? loginFlag,
    bool? admin,
    String? roleNames,
  }) =>
      Inspectors(
        id: id ?? this.id,
        loginFlag: loginFlag ?? this.loginFlag,
        admin: admin ?? this.admin,
        roleNames: roleNames ?? this.roleNames,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['loginFlag'] = loginFlag;
    map['admin'] = admin;
    map['roleNames'] = roleNames;
    return map;
  }
}

class User {
  User({
    this.id,
    this.loginFlag,
    this.admin,
    this.roleNames,
  });

  User.fromJson(dynamic json) {
    id = json['id'];
    loginFlag = json['loginFlag'];
    admin = json['admin'];
    roleNames = json['roleNames'];
  }

  String? id;
  String? loginFlag;
  bool? admin;
  String? roleNames;

  User copyWith({
    String? id,
    String? loginFlag,
    bool? admin,
    String? roleNames,
  }) =>
      User(
        id: id ?? this.id,
        loginFlag: loginFlag ?? this.loginFlag,
        admin: admin ?? this.admin,
        roleNames: roleNames ?? this.roleNames,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['loginFlag'] = loginFlag;
    map['admin'] = admin;
    map['roleNames'] = roleNames;
    return map;
  }
}
