class ExaminePersonBo {
  ExaminePersonBo({
    this.data,
    this.success,
  });

  ExaminePersonBo.fromJson(dynamic json) {
    data =
        json['data'] != null ? DataExaminePerson.fromJson(json['data']) : null;
    success = json['success'];
  }

  DataExaminePerson? data;
  bool? success;

  ExaminePersonBo copyWith({
    DataExaminePerson? data,
    bool? success,
  }) =>
      ExaminePersonBo(
        data: data ?? this.data,
        success: success ?? this.success,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (data != null) {
      map['data'] = data?.toJson();
    }
    map['success'] = success;
    return map;
  }
}

class DataExaminePerson {
  DataExaminePerson({
    this.id,
    this.inspectors,
    this.user,
    this.examDate,
    this.pdNum,
    this.xzNum,
    this.type,
    this.positionType,
  });

  DataExaminePerson.fromJson(dynamic json) {
    id = json['id'];
    inspectors = json['inspectors'] != null
        ? Inspectors.fromJson(json['inspectors'])
        : null;
    user = json['user'] != null ? User.fromJson(json['user']) : null;
    examDate = json['examDate'];
    pdNum = json['pdNum'];
    xzNum = json['xzNum'];
    type = json['type'] != null ? Type.fromJson(json['type']) : null;
    positionType = json['positionType'];
  }

  String? id;
  Inspectors? inspectors;
  User? user;
  String? examDate;
  int? pdNum;
  int? xzNum;
  Type? type;
  String? positionType;

  DataExaminePerson copyWith({
    String? id,
    Inspectors? inspectors,
    User? user,
    String? examDate,
    int? pdNum,
    int? xzNum,
    Type? type,
    String? positionType,
  }) =>
      DataExaminePerson(
        id: id ?? this.id,
        inspectors: inspectors ?? this.inspectors,
        user: user ?? this.user,
        examDate: examDate ?? this.examDate,
        pdNum: pdNum ?? this.pdNum,
        xzNum: xzNum ?? this.xzNum,
        type: type ?? this.type,
        positionType: positionType ?? this.positionType,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    if (inspectors != null) {
      map['inspectors'] = inspectors?.toJson();
    }
    if (user != null) {
      map['user'] = user?.toJson();
    }
    map['examDate'] = examDate;
    map['pdNum'] = pdNum;
    map['xzNum'] = xzNum;
    if (type != null) {
      map['type'] = type?.toJson();
    }
    map['positionType'] = positionType;
    return map;
  }
}

class Type {
  Type({
    this.id,
    this.name,
  });

  Type.fromJson(dynamic json) {
    id = json['id'];
    name = json['name'];
  }

  String? id;
  String? name;

  Type copyWith({
    String? id,
    String? name,
  }) =>
      Type(
        id: id ?? this.id,
        name: name ?? this.name,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['name'] = name;
    return map;
  }
}

class User {
  User({
    this.id,
    this.loginFlag,
    this.roleNames,
    this.admin,
  });

  User.fromJson(dynamic json) {
    id = json['id'];
    loginFlag = json['loginFlag'];
    roleNames = json['roleNames'];
    admin = json['admin'];
  }

  String? id;
  String? loginFlag;
  String? roleNames;
  bool? admin;

  User copyWith({
    String? id,
    String? loginFlag,
    String? roleNames,
    bool? admin,
  }) =>
      User(
        id: id ?? this.id,
        loginFlag: loginFlag ?? this.loginFlag,
        roleNames: roleNames ?? this.roleNames,
        admin: admin ?? this.admin,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['loginFlag'] = loginFlag;
    map['roleNames'] = roleNames;
    map['admin'] = admin;
    return map;
  }
}

class Inspectors {
  Inspectors({
    this.id,
    this.loginFlag,
    this.roleNames,
    this.admin,
  });

  Inspectors.fromJson(dynamic json) {
    id = json['id'];
    loginFlag = json['loginFlag'];
    roleNames = json['roleNames'];
    admin = json['admin'];
  }

  String? id;
  String? loginFlag;
  String? roleNames;
  bool? admin;

  Inspectors copyWith({
    String? id,
    String? loginFlag,
    String? roleNames,
    bool? admin,
  }) =>
      Inspectors(
        id: id ?? this.id,
        loginFlag: loginFlag ?? this.loginFlag,
        roleNames: roleNames ?? this.roleNames,
        admin: admin ?? this.admin,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['loginFlag'] = loginFlag;
    map['roleNames'] = roleNames;
    map['admin'] = admin;
    return map;
  }
}
