class ExamUnitList {
  ExamUnitList({
    this.officeList,
  });

  ExamUnitList.fromJson(dynamic json) {
    if (json['officeList'] != null) {
      officeList = [];
      json['officeList'].forEach((v) {
        officeList?.add(OfficeList.fromJson(v));
      });
    }
  }

  List<OfficeList>? officeList;

  ExamUnitList copyWith({
    List<OfficeList>? officeList,
  }) =>
      ExamUnitList(
        officeList: officeList ?? this.officeList,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (officeList != null) {
      map['officeList'] = officeList?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}

class OfficeList {
  OfficeList({
    this.id,
    this.name,
    this.sort,
    this.hasChildren,
    this.parentId,
  });

  OfficeList.fromJson(dynamic json) {
    id = json['id'];
    name = json['name'];
    sort = json['sort'];
    hasChildren = json['hasChildren'];
    parentId = json['parentId'];
  }

  String? id;
  String? name;
  num? sort;
  bool? hasChildren;
  String? parentId;

  OfficeList copyWith({
    String? id,
    String? name,
    num? sort,
    bool? hasChildren,
    String? parentId,
  }) =>
      OfficeList(
        id: id ?? this.id,
        name: name ?? this.name,
        sort: sort ?? this.sort,
        hasChildren: hasChildren ?? this.hasChildren,
        parentId: parentId ?? this.parentId,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['name'] = name;
    map['sort'] = sort;
    map['hasChildren'] = hasChildren;
    map['parentId'] = parentId;
    return map;
  }
}
