class ExamResultBo {
  ExamResultBo({
    this.data,
  });

  ExamResultBo.fromJson(dynamic json) {
    data = json['data'] != null ? ExamResultData.fromJson(json['data']) : null;
  }

  ExamResultData? data;

  ExamResultBo copyWith({
    ExamResultData? data,
  }) =>
      ExamResultBo(
        data: data ?? this.data,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (data != null) {
      map['data'] = data?.toJson();
    }
    return map;
  }
}

class ExamResultData {
  ExamResultData({
    this.id,
    this.name,
    this.questionNum,
    this.score,
    this.ccuracy,
    this.user,
    this.inspectors,
    this.correct,
    this.error,
    this.adopt,
    this.unit,
    this.dxNum,
    this.pdNum,
  });

  ExamResultData.fromJson(dynamic json) {
    id = json['id'];
    name = json['name'];
    questionNum = json['questionNum'];
    score = json['score'];
    ccuracy = json['ccuracy'];
    user = json['user'] != null ? User.fromJson(json['user']) : null;
    inspectors = json['inspectors'] != null
        ? Inspectors.fromJson(json['inspectors'])
        : null;
    correct = json['correct'];
    error = json['error'];
    adopt = json['adopt'];
    unit = json['unit'] != null ? Unit.fromJson(json['unit']) : null;
    dxNum = json['dxNum'];
    pdNum = json['pdNum'];
  }

  String? id;
  String? name;
  num? questionNum;
  num? score;
  num? ccuracy;
  User? user;
  Inspectors? inspectors;
  num? correct;
  num? error;
  String? adopt;
  Unit? unit;
  num? dxNum;
  num? pdNum;

  ExamResultData copyWith({
    String? id,
    String? name,
    num? questionNum,
    num? score,
    num? ccuracy,
    User? user,
    Inspectors? inspectors,
    num? correct,
    num? error,
    String? adopt,
    Unit? unit,
    num? dxNum,
    num? pdNum,
  }) =>
      ExamResultData(
        id: id ?? this.id,
        name: name ?? this.name,
        questionNum: questionNum ?? this.questionNum,
        score: score ?? this.score,
        ccuracy: ccuracy ?? this.ccuracy,
        user: user ?? this.user,
        inspectors: inspectors ?? this.inspectors,
        correct: correct ?? this.correct,
        error: error ?? this.error,
        adopt: adopt ?? this.adopt,
        unit: unit ?? this.unit,
        dxNum: dxNum ?? this.dxNum,
        pdNum: pdNum ?? this.pdNum,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['name'] = name;
    map['questionNum'] = questionNum;
    map['score'] = score;
    map['ccuracy'] = ccuracy;
    if (user != null) {
      map['user'] = user?.toJson();
    }
    if (inspectors != null) {
      map['inspectors'] = inspectors?.toJson();
    }
    map['correct'] = correct;
    map['error'] = error;
    map['adopt'] = adopt;
    if (unit != null) {
      map['unit'] = unit?.toJson();
    }
    map['dxNum'] = dxNum;
    map['pdNum'] = pdNum;
    return map;
  }
}

class Unit {
  Unit({
    this.id,
    this.name,
    this.sort,
    this.hasChildren,
    this.parentId,
  });

  Unit.fromJson(dynamic json) {
    id = json['id'];
    name = json['name'];
    sort = json['sort'];
    hasChildren = json['hasChildren'];
    parentId = json['parentId'];
  }

  String? id;
  String? name;
  num? sort;
  bool? hasChildren;
  String? parentId;

  Unit copyWith({
    String? id,
    String? name,
    num? sort,
    bool? hasChildren,
    String? parentId,
  }) =>
      Unit(
        id: id ?? this.id,
        name: name ?? this.name,
        sort: sort ?? this.sort,
        hasChildren: hasChildren ?? this.hasChildren,
        parentId: parentId ?? this.parentId,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['name'] = name;
    map['sort'] = sort;
    map['hasChildren'] = hasChildren;
    map['parentId'] = parentId;
    return map;
  }
}

class Inspectors {
  Inspectors({
    this.id,
    this.loginFlag,
    this.roleNames,
    this.admin,
  });

  Inspectors.fromJson(dynamic json) {
    id = json['id'];
    loginFlag = json['loginFlag'];
    roleNames = json['roleNames'];
    admin = json['admin'];
  }

  String? id;
  String? loginFlag;
  String? roleNames;
  bool? admin;

  Inspectors copyWith({
    String? id,
    String? loginFlag,
    String? roleNames,
    bool? admin,
  }) =>
      Inspectors(
        id: id ?? this.id,
        loginFlag: loginFlag ?? this.loginFlag,
        roleNames: roleNames ?? this.roleNames,
        admin: admin ?? this.admin,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['loginFlag'] = loginFlag;
    map['roleNames'] = roleNames;
    map['admin'] = admin;
    return map;
  }
}

class User {
  User({
    this.id,
    this.loginFlag,
    this.roleNames,
    this.admin,
  });

  User.fromJson(dynamic json) {
    id = json['id'];
    loginFlag = json['loginFlag'];
    roleNames = json['roleNames'];
    admin = json['admin'];
  }

  String? id;
  String? loginFlag;
  String? roleNames;
  bool? admin;

  User copyWith({
    String? id,
    String? loginFlag,
    String? roleNames,
    bool? admin,
  }) =>
      User(
        id: id ?? this.id,
        loginFlag: loginFlag ?? this.loginFlag,
        roleNames: roleNames ?? this.roleNames,
        admin: admin ?? this.admin,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['loginFlag'] = loginFlag;
    map['roleNames'] = roleNames;
    map['admin'] = admin;
    return map;
  }
}
