class EquipmentListBo {
  EquipmentListBo({
    this.list,
  });

  EquipmentListBo.fromJson(dynamic json) {
    if (json['list'] != null) {
      list = [];
      json['list'].forEach((v) {
        list?.add(EquiList.fromJson(v));
      });
    }
  }

  List<EquiList>? list;

  EquipmentListBo copyWith({
    List<EquiList>? list,
  }) =>
      EquipmentListBo(
        list: list ?? this.list,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (list != null) {
      map['list'] = list?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}

class EquiList {
  EquiList({
    this.id,
    this.name,
  });

  EquiList.fromJson(dynamic json) {
    id = json['id'];
    name = json['NAME'];
  }

  String? id;
  String? name;
  bool isChecked = false;

  EquiList copyWith({
    String? id,
    String? name,
  }) =>
      EquiList(
        id: id ?? this.id,
        name: name ?? this.name,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['NAME'] = name;
    return map;
  }
}
