class EquipmentBo {
  EquipmentBo({
    this.total,
    this.rows,
  });

  EquipmentBo.fromJson(dynamic json) {
    total = json['total'];
    if (json['rows'] != null) {
      rows = [];
      json['rows'].forEach((v) {
        rows?.add(Rows.fromJson(v));
      });
    }
  }

  int? total;
  List<Rows>? rows;

  EquipmentBo copyWith({
    int? total,
    List<Rows>? rows,
  }) =>
      EquipmentBo(
        total: total ?? this.total,
        rows: rows ?? this.rows,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['total'] = total;
    if (rows != null) {
      map['rows'] = rows?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}

class Rows {
  Rows({this.id, this.unitType, this.name});

  Rows.fromJson(dynamic json) {
    id = json['id'];
    unitType = json['unitType'];
    name = json['name'];
  }

  String? id;
  String? unitType;
  String? name;
  String? deviceTypeId;
  bool? isChecked = false;
  bool? isAQYChecked = false;

  Rows copyWith({String? id, String? unitType, String? name}) => Rows(
      id: id ?? this.id,
      unitType: unitType ?? this.unitType,
      name: name ?? this.name);

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['unitType'] = unitType;
    map['name'] = name;
    return map;
  }
}
