import 'package:special_equipment_flutter/model/role_bo.dart';

class DeviceListBo {
  DeviceListBo({
    this.data,
  });

  DeviceListBo.fromJson(dynamic json) {
    if (json['data'] != null) {
      data = [];
      json['data'].forEach((v) {
        data?.add(Data.fromJson(v));
      });
    }
  }

  List<Data>? data;

  DeviceListBo copyWith({
    List<Data>? data,
  }) =>
      DeviceListBo(
        data: data ?? this.data,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (data != null) {
      map['data'] = data?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}

class Data {
  Data({
    this.id,
    this.officeId,
    this.deviceTypeId,
    this.unitType,
    this.name,
    this.sort,
    this.delFlag,
    this.curType,
    this.certificateCode,
    this.certificateFile,
    this.dayBeginDate,
    this.weekBeginDate,
    this.monthBeginDate,
  });

  Data.fromJson(dynamic json) {
    id = json['id'];
    officeId = json['officeId'];
    deviceTypeId = json['deviceTypeId'];
    unitType = json['unitType'];
    name = json['name'];
    sort = json['sort'];
    delFlag = json['delFlag'];
    curType = json['curType'];
    certificateCode = json['certificateCode'];
    certificateFile = json['certificateFile'];
    dayBeginDate = json['dayBeginDate'];
    weekBeginDate = json['weekBeginDate'];
    monthBeginDate = json['monthBeginDate'];
  }

  String? id;
  String? officeId;
  String? deviceTypeId;
  String? unitType;
  String? name;
  String? sort;
  String? delFlag;
  String? curType;
  String? certificateCode;
  String? certificateFile;
  String? dayBeginDate;
  String? weekBeginDate;
  String? monthBeginDate;
  String? safetyOfficer = '';
  String? safetyDirector = '';
  List<UserData>? list = [];

  Data copyWith({
    String? id,
    String? officeId,
    String? deviceTypeId,
    String? unitType,
    String? name,
    String? sort,
    String? delFlag,
    String? curType,
    String? certificateCode,
    String? certificateFile,
    String? dayBeginDate,
    String? weekBeginDate,
    String? monthBeginDate,
  }) =>
      Data(
        id: id ?? this.id,
        officeId: officeId ?? this.officeId,
        deviceTypeId: deviceTypeId ?? this.deviceTypeId,
        unitType: unitType ?? this.unitType,
        name: name ?? this.name,
        sort: sort ?? this.sort,
        delFlag: delFlag ?? this.delFlag,
        curType: curType ?? this.curType,
        certificateCode: certificateCode ?? this.certificateCode,
        certificateFile: certificateFile ?? this.certificateFile,
        dayBeginDate: dayBeginDate ?? this.dayBeginDate,
        weekBeginDate: weekBeginDate ?? this.weekBeginDate,
        monthBeginDate: monthBeginDate ?? this.monthBeginDate,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['officeId'] = officeId;
    map['deviceTypeId'] = deviceTypeId;
    map['unitType'] = unitType;
    map['name'] = name;
    map['sort'] = sort;
    map['delFlag'] = delFlag;
    map['curType'] = curType;
    map['certificateCode'] = certificateCode;
    map['certificateFile'] = certificateFile;
    map['dayBeginDate'] = dayBeginDate;
    map['weekBeginDate'] = weekBeginDate;
    map['monthBeginDate'] = monthBeginDate;
    return map;
  }
}
