class UserList {
  UserList({
    this.total,
    this.rows,
  });

  UserList.fromJson(dynamic json) {
    total = json['total'];
    if (json['rows'] != null) {
      rows = [];
      json['rows'].forEach((v) {
        rows?.add(Rows.fromJson(v));
      });
    }
  }

  num? total;
  List<Rows>? rows;

  UserList copyWith({
    num? total,
    List<Rows>? rows,
  }) =>
      UserList(
        total: total ?? this.total,
        rows: rows ?? this.rows,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['total'] = total;
    if (rows != null) {
      map['rows'] = rows?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}

class Rows {
  Rows({
    this.id,
    this.office,
    this.loginName,
    this.name,
    this.mobile,
    this.loginFlag,
    this.userRoleList,
    this.admin,
    this.roleNames,
  });

  Rows.fromJson(dynamic json) {
    id = json['id'];
    office = json['office'] != null ? Office.fromJson(json['office']) : null;
    loginName = json['loginName'];
    name = json['name'];
    mobile = json['mobile'];
    loginFlag = json['loginFlag'];
    if (json['userRoleList'] != null) {
      userRoleList = [];
      json['userRoleList'].forEach((v) {
        userRoleList?.add(UserRoleList.fromJson(v));
      });
    }
    admin = json['admin'];
    roleNames = json['roleNames'];
  }

  String? id;
  Office? office;
  String? loginName;
  String? name;
  String? mobile;
  String? loginFlag;
  List<UserRoleList>? userRoleList;
  bool? admin;
  String? roleNames;

  Rows copyWith({
    String? id,
    Office? office,
    String? loginName,
    String? name,
    String? mobile,
    String? loginFlag,
    List<UserRoleList>? userRoleList,
    bool? admin,
    String? roleNames,
  }) =>
      Rows(
        id: id ?? this.id,
        office: office ?? this.office,
        loginName: loginName ?? this.loginName,
        name: name ?? this.name,
        mobile: mobile ?? this.mobile,
        loginFlag: loginFlag ?? this.loginFlag,
        userRoleList: userRoleList ?? this.userRoleList,
        admin: admin ?? this.admin,
        roleNames: roleNames ?? this.roleNames,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    if (office != null) {
      map['office'] = office?.toJson();
    }
    map['loginName'] = loginName;
    map['name'] = name;
    map['mobile'] = mobile;
    map['loginFlag'] = loginFlag;
    if (userRoleList != null) {
      map['userRoleList'] = userRoleList?.map((v) => v.toJson()).toList();
    }
    map['admin'] = admin;
    map['roleNames'] = roleNames;
    return map;
  }
}

class UserRoleList {
  UserRoleList({
    this.id,
    this.remarks,
    this.name,
    this.enname,
    this.roleType,
    this.sysData,
    this.useable,
    this.menuIds,
    this.dataRuleIds,
  });

  UserRoleList.fromJson(dynamic json) {
    id = json['id'];
    remarks = json['remarks'];
    name = json['name'];
    enname = json['enname'];
    roleType = json['roleType'];
    sysData = json['sysData'];
    useable = json['useable'];
    menuIds = json['menuIds'];
    dataRuleIds = json['dataRuleIds'];
  }

  String? id;
  String? remarks;
  String? name;
  String? enname;
  String? roleType;
  String? sysData;
  String? useable;
  String? menuIds;
  String? dataRuleIds;

  UserRoleList copyWith({
    String? id,
    String? remarks,
    String? name,
    String? enname,
    String? roleType,
    String? sysData,
    String? useable,
    String? menuIds,
    String? dataRuleIds,
  }) =>
      UserRoleList(
        id: id ?? this.id,
        remarks: remarks ?? this.remarks,
        name: name ?? this.name,
        enname: enname ?? this.enname,
        roleType: roleType ?? this.roleType,
        sysData: sysData ?? this.sysData,
        useable: useable ?? this.useable,
        menuIds: menuIds ?? this.menuIds,
        dataRuleIds: dataRuleIds ?? this.dataRuleIds,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['remarks'] = remarks;
    map['name'] = name;
    map['enname'] = enname;
    map['roleType'] = roleType;
    map['sysData'] = sysData;
    map['useable'] = useable;
    map['menuIds'] = menuIds;
    map['dataRuleIds'] = dataRuleIds;
    return map;
  }
}

class Office {
  Office({
    this.id,
    this.parentIds,
    this.name,
    this.sort,
    this.hasChildren,
    this.type,
    this.parentId,
  });

  Office.fromJson(dynamic json) {
    id = json['id'];
    parentIds = json['parentIds'];
    name = json['name'];
    sort = json['sort'];
    hasChildren = json['hasChildren'];
    type = json['type'];
    parentId = json['parentId'];
  }

  String? id;
  String? parentIds;
  String? name;
  num? sort;
  bool? hasChildren;
  String? type;
  String? parentId;

  Office copyWith({
    String? id,
    String? parentIds,
    String? name,
    num? sort,
    bool? hasChildren,
    String? type,
    String? parentId,
  }) =>
      Office(
        id: id ?? this.id,
        parentIds: parentIds ?? this.parentIds,
        name: name ?? this.name,
        sort: sort ?? this.sort,
        hasChildren: hasChildren ?? this.hasChildren,
        type: type ?? this.type,
        parentId: parentId ?? this.parentId,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['parentIds'] = parentIds;
    map['name'] = name;
    map['sort'] = sort;
    map['hasChildren'] = hasChildren;
    map['type'] = type;
    map['parentId'] = parentId;
    return map;
  }
}
