class DeviceBo {
  DeviceBo({
    this.id,
    this.name,
    this.address,
    this.code,
    this.deviceType,
    this.user,
  });

  DeviceBo.fromJson(dynamic json) {
    id = json['id'];
    name = json['name'];
    address = json['address'];
    code = json['code'];
    deviceType = json['deviceType'] != null
        ? DeviceTypes.fromJson(json['deviceType'])
        : null;
    user = json['user'] != null ? Users.fromJson(json['user']) : null;
  }

  String? id;
  String? name;
  String? address;
  String? code;
  DeviceTypes? deviceType;
  Users? user;

  DeviceBo copyWith({
    String? id,
    String? name,
    String? address,
    String? code,
    DeviceTypes? deviceType,
    Users? user,
  }) =>
      DeviceBo(
        id: id ?? this.id,
        name: name ?? this.name,
        address: address ?? this.address,
        code: code ?? this.code,
        deviceType: deviceType ?? this.deviceType,
        user: user ?? this.user,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['name'] = name;
    map['address'] = address;
    map['code'] = code;
    if (deviceType != null) {
      map['deviceType'] = deviceType?.toJson();
    }
    if (user != null) {
      map['user'] = user?.toJson();
    }
    return map;
  }
}

class Users {
  Users({
    this.id,
  });

  Users.fromJson(dynamic json) {
    id = json['id'];
  }

  String? id;

  Users copyWith({
    String? id,
  }) =>
      Users(
        id: id ?? this.id,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    return map;
  }
}

class DeviceTypes {
  DeviceTypes({
    this.id,
  });

  DeviceTypes.fromJson(dynamic json) {
    id = json['id'];
  }

  String? id;

  DeviceTypes copyWith({
    String? id,
  }) =>
      DeviceTypes(
        id: id ?? this.id,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    return map;
  }
}
