import 'package:special_equipment_flutter/model/detail/week/task_week.dart';
import 'package:special_equipment_flutter/model/detail/week/task_week_check_dto_list.dart';

/// taskWeek : {"id":"1801118fe5414fada7a3929cfc7cc6b4"}
/// taskWeekCheckDtoList : [{"deviceRisk":{"id":"989bf0708d85409c9e0db505ed94a6fc","name":"人员","sort":1,"hasChildren":false,"riskMeasure":"","inspectType":"","isShow":"1","parentId":"0"},"childTaskWeekList":[{"deviceRisk":{"id":"be8a45f864e14b159729e087da8ac499","parentIds":"0,9190984781f44226b984c363bce91663,989bf0708d85409c9e0db505ed94a6fc,","name":"作业人员未持有相应资格证件","sort":2,"hasChildren":false,"riskMeasure":"配备具有相应职责资质的作业人员，加强资格证的换证管理","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240"},"inspectType":"2","isShow":"1","parentId":"989bf0708d85409c9e0db505ed94a6fc"},"sort":2},{"deviceRisk":{"id":"c787a874637041d7a18e3a32c908492b","parentIds":"0,9190984781f44226b984c363bce91663,989bf0708d85409c9e0db505ed94a6fc,","name":"未按规定对安全管理人员和作业人员开展安全教育培训","sort":3,"hasChildren":false,"riskMeasure":"按规定开展安全培训教育","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240"},"inspectType":"2","isShow":"1","parentId":"989bf0708d85409c9e0db505ed94a6fc"},"sort":3}],"sort":1},{"deviceRisk":{"id":"c9d97ba7ae2f4015a58797782bfcbfe1","name":"管理","sort":2,"hasChildren":false,"riskMeasure":"","inspectType":"","isShow":"1","parentId":"0"},"childTaskWeekList":[{"deviceRisk":{"id":"52da2ceffa2a4f6991c6ba972a93dd44","parentIds":"0,9190984781f44226b984c363bce91663,c9d97ba7ae2f4015a58797782bfcbfe1,","name":"未建立锅炉使用安全节能管理制度","sort":2,"hasChildren":false,"riskMeasure":"1．制定锅炉安全管理机构和相关人员岗位职责； 2．制定《锅炉安全总监职责》《锅炉安全员守则》《锅炉安全日管控、周排查、月调度管理制度》； 3.按《特种设备使用管理规则》建立锅炉使用安全和节能管理制度 。","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240"},"inspectType":"2","isShow":"1","parentId":"c9d97ba7ae2f4015a58797782bfcbfe1"},"sort":2},{"deviceRisk":{"id":"831af07888424d5bb88cc138ae4b530f","parentIds":"0,9190984781f44226b984c363bce91663,c9d97ba7ae2f4015a58797782bfcbfe1,","name":"未建立安全技术档案","sort":3,"hasChildren":false,"riskMeasure":"建立锅炉安全技术档案管理制度，明确档案内容及管理要求； 2.按规定逐台建立安全技术档案并及时更新安全技术档案。","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240"},"inspectType":"2","isShow":"1","parentId":"c9d97ba7ae2f4015a58797782bfcbfe1"},"sort":3},{"deviceRisk":{"id":"c2d1784458c646d8b34c57c034800830","parentIds":"0,9190984781f44226b984c363bce91663,c9d97ba7ae2f4015a58797782bfcbfe1,","name":"未按规定办理使用登记、变更登记及停用、报废等手续","sort":4,"hasChildren":false,"riskMeasure":"1.建立使用管理制度和规程，明确相关内容及安全管理要求； 2. 按规定办理使用登记、变更登记及停用、报废手续。","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240"},"inspectType":"2","isShow":"1","parentId":"c9d97ba7ae2f4015a58797782bfcbfe1"},"sort":4},{"deviceRisk":{"id":"8e1b6f2222f04bada2d1d11eaf0bd4c7","parentIds":"0,9190984781f44226b984c363bce91663,c9d97ba7ae2f4015a58797782bfcbfe1,","name":"锅炉停炉期间未按规定对锅炉及水处理设备进行停炉保养","sort":6,"hasChildren":false,"riskMeasure":"1.制定并落实锅炉停炉期间的锅炉、水处理设备保养措施； 2.加强锅炉管理人员、操作人员、维护保养人员的相关专业培训。","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240"},"inspectType":"2","isShow":"1","parentId":"c9d97ba7ae2f4015a58797782bfcbfe1"},"sort":6}],"sort":2},{"deviceRisk":{"id":"e087db9a4ab7491389d70344e22ea7b8","name":"锅炉本体及锅炉范围内管道","sort":3,"hasChildren":false,"riskMeasure":"","inspectType":"","isShow":"1","parentId":"0"},"childTaskWeekList":[{"deviceRisk":{"id":"0845b5032fbb4dfaa921b4119cb49153","parentIds":"0,9190984781f44226b984c363bce91663,e087db9a4ab7491389d70344e22ea7b8,","name":"未按规定调试、检查和启动锅炉","sort":2,"hasChildren":false,"riskMeasure":"1.制定调试方案，调试过程中的技术、安全保障措施，规定进行调试并记录； 2.按操作规程进行启动前检查和启动程序。","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240"},"inspectType":"2","isShow":"1","parentId":"e087db9a4ab7491389d70344e22ea7b8"},"sort":2}],"sort":3},{"deviceRisk":{"id":"66e52f9b19b04139bffb72761adeed1b","name":"安全附件和安全保护装置","sort":4,"hasChildren":false,"riskMeasure":"","inspectType":"","isShow":"1","parentId":"0"},"childTaskWeekList":[{"deviceRisk":{"id":"d8e70fdf1ffe4895a34c1e6316c0f894","parentIds":"0,9190984781f44226b984c363bce91663,66e52f9b19b04139bffb72761adeed1b,","name":"控制式安全阀控制系统未定期试验、安全阀未定期校验、安全阀未进行定期排放试验","sort":1,"hasChildren":false,"riskMeasure":"1.制定安全附件定期试验、校验、维护保养管理制度，并严格执行； 2.落实专人定期开展校验或试验。","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240"},"inspectType":"2","isShow":"1","parentId":"66e52f9b19b04139bffb72761adeed1b"},"sort":1},{"deviceRisk":{"id":"1f731e521a7a4e0b91050b19de338b24","parentIds":"0,9190984781f44226b984c363bce91663,66e52f9b19b04139bffb72761adeed1b,","name":"压力表未按规定进行检定或者校准","sort":2,"hasChildren":false,"riskMeasure":"1.制定安全附件定期试验、校验、维护保养管理制度，并严格执行； 2.落实专人定期开展送检或检查。","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240"},"inspectType":"2","isShow":"1","parentId":"66e52f9b19b04139bffb72761adeed1b"},"sort":2},{"deviceRisk":{"id":"001194f4db084cebbea130be540bb67e","parentIds":"0,9190984781f44226b984c363bce91663,66e52f9b19b04139bffb72761adeed1b,","name":"远程水（液）位测量装置与就地水（液）位表未校对","sort":5,"hasChildren":false,"riskMeasure":"定期对水位计进行维护保养、更换、冲洗、校对等。","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240"},"inspectType":"2","isShow":"1","parentId":"66e52f9b19b04139bffb72761adeed1b"},"sort":5},{"deviceRisk":{"id":"b9c9c3463e7041709d6b26a006f8c9ee","parentIds":"0,9190984781f44226b984c363bce91663,66e52f9b19b04139bffb72761adeed1b,","name":"温度测量装置未按规定校验或者校准","sort":6,"hasChildren":false,"riskMeasure":"落实专人定期开展送检或检查","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240"},"inspectType":"2","isShow":"1","parentId":"66e52f9b19b04139bffb72761adeed1b"},"sort":6},{"deviceRisk":{"id":"2d1e4b17c13a43a0aeaefc8025ebadb1","parentIds":"0,9190984781f44226b984c363bce91663,66e52f9b19b04139bffb72761adeed1b,","name":"水位、压力、温度、点火程序控制、熄火保护等联锁保护装置的设置不符合要求","sort":8,"hasChildren":false,"riskMeasure":"1.对安全保护装置进行调试、验收； 2、对安全保护装置定期进行维护保养和试验并作出记录。","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240"},"inspectType":"2","isShow":"1","parentId":"66e52f9b19b04139bffb72761adeed1b"},"sort":8}],"sort":4},{"deviceRisk":{"id":"1bdd34937c9d4b23ac37e3371247ea14","name":"环境因素","sort":5,"hasChildren":false,"riskMeasure":"","inspectType":"","isShow":"1","parentId":"0"},"childTaskWeekList":[{"deviceRisk":{"id":"37855605b793458aa72141f6e6feac38","parentIds":"0,9190984781f44226b984c363bce91663,1bdd34937c9d4b23ac37e3371247ea14,","name":"锅炉周围的安全通道、照明、防火、防雷、防风、防雨、防冻、防腐设施以及警示标志的设置不符合要求","sort":1,"hasChildren":false,"riskMeasure":"1.制定锅炉房安全管理制度，明确锅炉房管理的要求； 2.锅炉房维修、改造时应满足GB 50041《锅炉房设计标准》、GB 50016《建筑设计防火规范》等规定，并形成验收记录； 3.按规定设置警示标志，禁止非锅炉作业人员随意进入锅炉房。","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240"},"inspectType":"2","isShow":"1","parentId":"1bdd34937c9d4b23ac37e3371247ea14"},"sort":1}],"sort":5},{"deviceRisk":{"id":"8cbd202ee3b14cd4ab2ad59c2c3dab67","name":"热水锅炉专项","sort":6,"hasChildren":false,"riskMeasure":"","inspectType":"","isShow":"1","parentId":"0"},"childTaskWeekList":[{"deviceRisk":{"id":"ddbb8bc8f1a1445d8dfbc4368b25b2dd","parentIds":"0,9190984781f44226b984c363bce91663,8cbd202ee3b14cd4ab2ad59c2c3dab67,","name":"自动补给水装置不符合要求","sort":1,"hasChildren":false,"riskMeasure":"按规定进行维护保养、检查和试验，发现异常，按规定进行报告和处理","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240"},"inspectType":"2","isShow":"1","parentId":"8cbd202ee3b14cd4ab2ad59c2c3dab67"},"sort":1}],"sort":6},{"deviceRisk":{"id":"f05af6cccc3a4b95b1b64ac4f7fdb98d","name":"有机热载体锅炉专项","sort":7,"hasChildren":false,"riskMeasure":"","inspectType":"","isShow":"1","parentId":"0"},"childTaskWeekList":[{"deviceRisk":{"id":"1306e50f245f456fbf509decc2eef595","parentIds":"0,9190984781f44226b984c363bce91663,f05af6cccc3a4b95b1b64ac4f7fdb98d,","name":"有机热载体未按规定进行检验或检验不符合要求","sort":1,"hasChildren":false,"riskMeasure":"定期对有机热载体按规定取样检验","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240"},"inspectType":"2","isShow":"1","parentId":"f05af6cccc3a4b95b1b64ac4f7fdb98d"},"sort":1}],"sort":7},{"deviceRisk":{"id":"030b8bae0b31425b9a15f1d2de95aeef","name":"D级锅炉专项","sort":8,"hasChildren":false,"riskMeasure":"","inspectType":"","isShow":"1","parentId":"0"},"childTaskWeekList":[{"deviceRisk":{"id":"d961dea6b4e448fda21abaef413704a1","parentIds":"0,9190984781f44226b984c363bce91663,030b8bae0b31425b9a15f1d2de95aeef,","name":"未对作业人员进行培训","sort":1,"hasChildren":false,"riskMeasure":"定期对锅炉操作人员进行安全操作、安全管理和应急处置等进行培训","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240"},"inspectType":"2","isShow":"1","parentId":"030b8bae0b31425b9a15f1d2de95aeef"},"sort":1},{"deviceRisk":{"id":"b438350734874a9cbc8edcf878332323","parentIds":"0,9190984781f44226b984c363bce91663,030b8bae0b31425b9a15f1d2de95aeef,","name":"未开展定期自行检查，未对安全附件定期维护","sort":2,"hasChildren":false,"riskMeasure":"按规定进行维护保养和定期自行检查","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240"},"inspectType":"2","isShow":"1","parentId":"030b8bae0b31425b9a15f1d2de95aeef"},"sort":2},{"deviceRisk":{"id":"2071b6784129488fb4054bb7b70b047d","parentIds":"0,9190984781f44226b984c363bce91663,030b8bae0b31425b9a15f1d2de95aeef,","name":"擅自对锅炉进行改造","sort":3,"hasChildren":false,"riskMeasure":"发现擅自改造立即停止运行，做进一步处理","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240"},"inspectType":"2","isShow":"1","parentId":"030b8bae0b31425b9a15f1d2de95aeef"},"sort":3}],"sort":8},{"deviceRisk":{"id":"73060427fc8749c8894bef79531369b9","parentIds":"0,9190984781f44226b984c363bce91663,","name":"政府监督、通报、预警","sort":9,"hasChildren":false,"riskMeasure":"","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240"},"inspectType":"2","isShow":"0","parentId":"9190984781f44226b984c363bce91663"},"sort":9}]

class WeekDetailBo {
  WeekDetailBo({
    TaskWeek? taskWeek,
    List<TaskWeekCheckDtoList>? taskWeekCheckDtoList,
  }) {
    _taskWeek = taskWeek;
    _taskWeekCheckDtoList = taskWeekCheckDtoList;
  }

  WeekDetailBo.fromJson(dynamic json) {
    _taskWeek =
        json['taskWeek'] != null ? TaskWeek.fromJson(json['taskWeek']) : null;
    if (json['taskWeekCheckDtoList'] != null) {
      _taskWeekCheckDtoList = [];
      json['taskWeekCheckDtoList'].forEach((v) {
        _taskWeekCheckDtoList?.add(TaskWeekCheckDtoList.fromJson(v));
      });
    }
  }

  TaskWeek? _taskWeek;
  List<TaskWeekCheckDtoList>? _taskWeekCheckDtoList;

  WeekDetailBo copyWith({
    TaskWeek? taskWeek,
    List<TaskWeekCheckDtoList>? taskWeekCheckDtoList,
  }) =>
      WeekDetailBo(
        taskWeek: taskWeek ?? _taskWeek,
        taskWeekCheckDtoList: taskWeekCheckDtoList ?? _taskWeekCheckDtoList,
      );

  TaskWeek? get taskWeek => _taskWeek;

  List<TaskWeekCheckDtoList>? get taskWeekCheckDtoList => _taskWeekCheckDtoList;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (_taskWeek != null) {
      map['taskWeek'] = _taskWeek?.toJson();
    }
    if (_taskWeekCheckDtoList != null) {
      map['taskWeekCheckDtoList'] =
          _taskWeekCheckDtoList?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}
