import '../device_risk.dart';
import 'child_task_week_list.dart';

/// deviceRisk : {"id":"989bf0708d85409c9e0db505ed94a6fc","name":"人员","sort":1,"hasChildren":false,"riskMeasure":"","inspectType":"","isShow":"1","parentId":"0"}
/// childTaskWeekList : [{"deviceRisk":{"id":"be8a45f864e14b159729e087da8ac499","parentIds":"0,9190984781f44226b984c363bce91663,989bf0708d85409c9e0db505ed94a6fc,","name":"作业人员未持有相应资格证件","sort":2,"hasChildren":false,"riskMeasure":"配备具有相应职责资质的作业人员，加强资格证的换证管理","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240"},"inspectType":"2","isShow":"1","parentId":"989bf0708d85409c9e0db505ed94a6fc"},"sort":2},{"deviceRisk":{"id":"c787a874637041d7a18e3a32c908492b","parentIds":"0,9190984781f44226b984c363bce91663,989bf0708d85409c9e0db505ed94a6fc,","name":"未按规定对安全管理人员和作业人员开展安全教育培训","sort":3,"hasChildren":false,"riskMeasure":"按规定开展安全培训教育","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240"},"inspectType":"2","isShow":"1","parentId":"989bf0708d85409c9e0db505ed94a6fc"},"sort":3}]
/// sort : 1

class TaskWeekCheckDtoList {
  TaskWeekCheckDtoList({
    DeviceRisk? deviceRisk,
    List<ChildTaskWeekList>? childTaskWeekList,
    int? sort,
  }) {
    _deviceRisk = deviceRisk;
    _childTaskWeekList = childTaskWeekList;
    _sort = sort;
  }

  TaskWeekCheckDtoList.fromJson(dynamic json) {
    _deviceRisk = json['deviceRisk'] != null
        ? DeviceRisk.fromJson(json['deviceRisk'])
        : null;
    if (json['childTaskWeekList'] != null) {
      _childTaskWeekList = [];
      json['childTaskWeekList'].forEach((v) {
        _childTaskWeekList?.add(ChildTaskWeekList.fromJson(v));
      });
    }
    _sort = json['sort'];
  }

  DeviceRisk? _deviceRisk;
  List<ChildTaskWeekList>? _childTaskWeekList;
  int? _sort;

  TaskWeekCheckDtoList copyWith({
    DeviceRisk? deviceRisk,
    List<ChildTaskWeekList>? childTaskWeekList,
    int? sort,
  }) =>
      TaskWeekCheckDtoList(
        deviceRisk: deviceRisk ?? _deviceRisk,
        childTaskWeekList: childTaskWeekList ?? _childTaskWeekList,
        sort: sort ?? _sort,
      );

  DeviceRisk? get deviceRisk => _deviceRisk;

  List<ChildTaskWeekList>? get childTaskWeekList => _childTaskWeekList;

  int? get sort => _sort;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (_deviceRisk != null) {
      map['deviceRisk'] = _deviceRisk?.toJson();
    }
    if (_childTaskWeekList != null) {
      map['childTaskWeekList'] =
          _childTaskWeekList?.map((v) => v.toJson()).toList();
    }
    map['sort'] = _sort;
    return map;
  }
}
