import 'package:special_equipment_flutter/model/detail/week/task_week.dart';
import 'package:special_equipment_flutter/utils/storage_util.dart';

import '../device_risk.dart';
import '../device_risk_parent.dart';

class TaskWeekCheck {
  TaskWeekCheck({
    String? id,
    String? createDate,
    String? updateDate,
    TaskWeek? taskWeek,
    DeviceRisk? deviceRisk,
    DeviceRiskParent? deviceRiskParent,
    String? name,
    String? riskContent,
    String? result,
    String? rectHave,
    String? rectContent,
    String? rectUserName,
    String? rectTime,
    int? sort,
    String? hiddenText,
    String? hiddenName,
    String? hiddenContent,
  }) {
    _id = id;
    _createDate = createDate;
    _updateDate = updateDate;
    _taskWeek = taskWeek;
    _deviceRisk = deviceRisk;
    _deviceRiskParent = deviceRiskParent;
    _name = name;
    _result = result;
    _riskContent = riskContent;
    _rectHave = rectHave;
    _rectContent = rectContent;
    _rectUserName = rectUserName;
    _rectTime = rectTime;
    _sort = sort;
    _hiddenText = hiddenText;
    _hiddenName = hiddenName;
    _hiddenContent = hiddenContent;
  }

  TaskWeekCheck.fromJson(dynamic json) {
    _id = json['id'];
    _createDate = json['createDate'];
    _updateDate = json['updateDate'];
    _taskWeek =
        json['taskWeek'] != null ? TaskWeek.fromJson(json['taskWeek']) : null;
    _deviceRisk = json['deviceRisk'] != null
        ? DeviceRisk.fromJson(json['deviceRisk'])
        : null;
    _deviceRiskParent = json['deviceRiskParent'] != null
        ? DeviceRiskParent.fromJson(json['deviceRiskParent'])
        : null;
    _name = json['name'];
    _result = json['result'];
    _riskContent = json['riskContent'];
    _rectHave = json['rectHave'];
    _rectContent = json['rectContent'];
    _rectUserName = json['rectUserName'];
    _rectTime = json['rectTime'];
    _sort = json['sort'];
  }

  String? _id;
  String? _createDate;
  String? _updateDate;
  TaskWeek? _taskWeek;
  DeviceRisk? _deviceRisk;
  DeviceRiskParent? _deviceRiskParent;
  String? _name;
  String? _result;
  String? _riskContent;
  String? _rectHave;
  String? _rectContent;
  String? _rectUserName;
  String? _rectTime;
  int? _sort;
  String? _hiddenText = '去整改';
  String? _hiddenContent = '';
  String? _hiddenName = StorageUtil.getInstance().getName();

  TaskWeekCheck copyWith({
    String? id,
    String? createDate,
    String? updateDate,
    TaskWeek? taskWeek,
    DeviceRisk? deviceRisk,
    DeviceRiskParent? deviceRiskParent,
    String? name,
    String? result,
    String? riskContent,
    String? rectHave,
    String? rectContent,
    String? rectUserName,
    String? rectTime,
    int? sort,
  }) =>
      TaskWeekCheck(
        id: id ?? _id,
        createDate: createDate ?? _createDate,
        updateDate: updateDate ?? _updateDate,
        taskWeek: taskWeek ?? _taskWeek,
        deviceRisk: deviceRisk ?? _deviceRisk,
        deviceRiskParent: deviceRiskParent ?? _deviceRiskParent,
        name: name ?? _name,
        result: result ?? _result,
        rectHave: rectHave ?? _rectHave,
        riskContent: riskContent ?? _riskContent,
        rectContent: rectContent ?? _rectContent,
        rectUserName: rectUserName ?? _rectUserName,
        rectTime: rectTime ?? _rectTime,
        sort: sort ?? _sort,
      );

  String? get id => _id;

  String? get createDate => _createDate;

  String? get updateDate => _updateDate;

  TaskWeek? get taskWeek => _taskWeek;

  DeviceRisk? get deviceRisk => _deviceRisk;

  DeviceRiskParent? get deviceRiskParent => _deviceRiskParent;

  String? get name => _name;

  String? get result => _result;

  String? get rectHave => _rectHave;

  String? get riskContent => _riskContent;

  String? get rectContent => _rectContent;

  String? get rectUserName => _rectUserName;

  String? get rectTime => _rectTime;

  int? get sort => _sort;

  String? get hiddenText => _hiddenText;

  String? get hiddenContent => _hiddenContent;

  String? get hiddenName => _hiddenName;

  set riskContent(String? riskContent) {
    _riskContent = riskContent;
  }

  set hiddenText(String? hiddenText) {
    _hiddenText = hiddenText;
  }

  set hiddenContent(String? hiddenContent) {
    _hiddenContent = hiddenContent;
  }

  // 定义 isChecked 的 setter 方法
  set hiddenName(String? hiddenName) {
    _hiddenName = hiddenName;
  }

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = _id;
    map['createDate'] = _createDate;
    map['updateDate'] = _updateDate;
    if (_taskWeek != null) {
      map['taskWeek'] = _taskWeek?.toJson();
    }
    if (_deviceRisk != null) {
      map['deviceRisk'] = _deviceRisk?.toJson();
    }
    if (_deviceRiskParent != null) {
      map['deviceRiskParent'] = _deviceRiskParent?.toJson();
    }
    map['name'] = _name;
    map['result'] = _result;
    map['rectHave'] = _rectHave;
    map['riskContent'] = _riskContent;
    map['rectContent'] = _rectContent;
    map['rectUserName'] = _rectUserName;
    map['rectTime'] = _rectTime;
    map['sort'] = _sort;
    return map;
  }
}
