import '../device_risk.dart';
import 'task_week_check.dart';

/// deviceRisk : {"id":"be8a45f864e14b159729e087da8ac499","parentIds":"0,9190984781f44226b984c363bce91663,989bf0708d85409c9e0db505ed94a6fc,","name":"作业人员未持有相应资格证件","sort":2,"hasChildren":false,"riskMeasure":"配备具有相应职责资质的作业人员，加强资格证的换证管理","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240"},"inspectType":"2","isShow":"1","parentId":"989bf0708d85409c9e0db505ed94a6fc"}
/// sort : 2

class ChildTaskWeekList {
  ChildTaskWeekList({
    DeviceRisk? deviceRisk,
    int? sort,
    TaskWeekCheck? taskWeekCheck,
  }) {
    _deviceRisk = deviceRisk;
    _sort = sort;
    _taskWeekCheck = taskWeekCheck;
  }

  ChildTaskWeekList.fromJson(dynamic json) {
    _deviceRisk = json['deviceRisk'] != null
        ? DeviceRisk.fromJson(json['deviceRisk'])
        : null;
    _sort = json['sort'];
    _taskWeekCheck = json['taskWeekCheck'] != null
        ? TaskWeekCheck.fromJson(json['taskWeekCheck'])
        : null;
  }

  DeviceRisk? _deviceRisk;
  int? _sort;
  TaskWeekCheck? _taskWeekCheck;

  ChildTaskWeekList copyWith({
    DeviceRisk? deviceRisk,
    int? sort,
    TaskWeekCheck? taskWeekCheck,
  }) =>
      ChildTaskWeekList(
        deviceRisk: deviceRisk ?? _deviceRisk,
        sort: sort ?? _sort,
        taskWeekCheck: taskWeekCheck ?? _taskWeekCheck,
      );

  DeviceRisk? get deviceRisk => _deviceRisk;

  int? get sort => _sort;

  TaskWeekCheck? get taskWeekCheck => _taskWeekCheck;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (_deviceRisk != null) {
      map['deviceRisk'] = _deviceRisk?.toJson();
    }
    map['sort'] = _sort;
    map['taskWeekCheck'] = _taskWeekCheck?.toJson();

    return map;
  }
}
