import '../device_risk.dart';
import 'child_task_month_list.dart';

/// deviceRisk : {"id":"7a3cd4ca02114e6f81839d5221799901","name":"人员","sort":1,"hasChildren":false,"riskMeasure":"","inspectType":"","isShow":"1","parentId":"0"}
/// childTaskMonthList : [{"deviceRisk":{"id":"a436d5b2c8924084b46effd4572649c1","parentIds":"0,95b688b736eb486c8204964183e91d56,7a3cd4ca02114e6f81839d5221799901,","name":"作业人员未持有相应资格证件","sort":2,"hasChildren":false,"riskMeasure":"配备具有相应职责资质的作业人员，加强资格证的换证管理","deviceType":{"id":"779d6023cd4148b49288eb3e3616a7e3"},"inspectType":"2","isShow":"1","parentId":"7a3cd4ca02114e6f81839d5221799901"},"sort":2},{"deviceRisk":{"id":"b6dc48e360224039bb16651637129d19","parentIds":"0,95b688b736eb486c8204964183e91d56,7a3cd4ca02114e6f81839d5221799901,","name":"未按规定对安全管理人员和作业人员开展安全教育培训","sort":3,"hasChildren":false,"riskMeasure":"按规定开展安全培训教育","deviceType":{"id":"779d6023cd4148b49288eb3e3616a7e3"},"inspectType":"2","isShow":"1","parentId":"7a3cd4ca02114e6f81839d5221799901"},"sort":3}]
/// sort : 1

class TaskMonthCheckDtoList {
  TaskMonthCheckDtoList({
    DeviceRisk? deviceRisk,
    List<ChildTaskMonthList>? childTaskMonthList,
    int? sort,
  }) {
    _deviceRisk = deviceRisk;
    _childTaskMonthList = childTaskMonthList;
    _sort = sort;
  }

  TaskMonthCheckDtoList.fromJson(dynamic json) {
    _deviceRisk = json['deviceRisk'] != null
        ? DeviceRisk.fromJson(json['deviceRisk'])
        : null;
    if (json['childTaskMonthList'] != null) {
      _childTaskMonthList = [];
      json['childTaskMonthList'].forEach((v) {
        _childTaskMonthList?.add(ChildTaskMonthList.fromJson(v));
      });
    }
    _sort = json['sort'];
  }

  DeviceRisk? _deviceRisk;
  List<ChildTaskMonthList>? _childTaskMonthList;
  int? _sort;

  TaskMonthCheckDtoList copyWith({
    DeviceRisk? deviceRisk,
    List<ChildTaskMonthList>? childTaskMonthList,
    int? sort,
  }) =>
      TaskMonthCheckDtoList(
        deviceRisk: deviceRisk ?? _deviceRisk,
        childTaskMonthList: childTaskMonthList ?? _childTaskMonthList,
        sort: sort ?? _sort,
      );

  DeviceRisk? get deviceRisk => _deviceRisk;

  List<ChildTaskMonthList>? get childTaskMonthList => _childTaskMonthList;

  int? get sort => _sort;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (_deviceRisk != null) {
      map['deviceRisk'] = _deviceRisk?.toJson();
    }
    if (_childTaskMonthList != null) {
      map['childTaskMonthList'] =
          _childTaskMonthList?.map((v) => v.toJson()).toList();
    }
    map['sort'] = _sort;
    return map;
  }
}
