import 'package:special_equipment_flutter/utils/storage_util.dart';

import '../device_risk.dart';
import '../device_risk_parent.dart';
import 'task_month.dart';

/// id : "e29276893dd74496ad4b54658137365d"
/// createBy : {"id":"1af9c361da644d408c074d51e076fcdc","loginFlag":"1","roleNames":"","admin":false}
/// createDate : "2023-10-24 16:19:44"
/// updateBy : {"id":"1af9c361da644d408c074d51e076fcdc","loginFlag":"1","roleNames":"","admin":false}
/// updateDate : "2023-10-24 16:19:44"
/// taskMonth : {"id":"c0186c8e9c1240e98aa8f24cc3162243"}
/// deviceRisk : {"id":"a436d5b2c8924084b46effd4572649c1","name":"作业人员未持有相应资格证件","sort":2,"hasChildren":false,"riskMeasure":"配备具有相应职责资质的作业人员，加强资格证的换证管理","isShow":"1","parentId":"0"}
/// deviceRiskParent : {"id":"7a3cd4ca02114e6f81839d5221799901","name":"人员","sort":1,"hasChildren":false,"riskMeasure":"","isShow":"1","parentId":"0"}
/// name : "作业人员未持有相应资格证件"
/// result : "2"
/// riskContent : "看考场可防可控"
/// rectHave : ""
/// rectContent : ""
/// rectUserName : ""
/// sort : 2

class TaskMonthCheck {
  TaskMonthCheck({
    String? id,
    String? createDate,
    String? updateDate,
    TaskMonth? taskMonth,
    DeviceRisk? deviceRisk,
    DeviceRiskParent? deviceRiskParent,
    String? name,
    String? result,
    String? riskContent,
    String? rectHave,
    String? rectContent,
    String? rectUserName,
    String? rectTime,
    int? sort,
    String? hiddenText,
    String? hiddenName,
    String? hiddenContent,
  }) {
    _id = id;
    _createDate = createDate;
    _updateDate = updateDate;
    _taskMonth = taskMonth;
    _deviceRisk = deviceRisk;
    _deviceRiskParent = deviceRiskParent;
    _name = name;
    _result = result;
    _riskContent = riskContent;
    _rectHave = rectHave;
    _rectContent = rectContent;
    _rectUserName = rectUserName;
    _rectTime = rectTime;
    _sort = sort;
    _hiddenText = hiddenText;
    _hiddenName = hiddenName;
    _hiddenContent = hiddenContent;
  }

  TaskMonthCheck.fromJson(dynamic json) {
    _id = json['id'];
    _createDate = json['createDate'];
    _updateDate = json['updateDate'];
    _taskMonth = json['taskMonth'] != null
        ? TaskMonth.fromJson(json['taskMonth'])
        : null;
    _deviceRisk = json['deviceRisk'] != null
        ? DeviceRisk.fromJson(json['deviceRisk'])
        : null;
    _deviceRiskParent = json['deviceRiskParent'] != null
        ? DeviceRiskParent.fromJson(json['deviceRiskParent'])
        : null;
    _name = json['name'];
    _result = json['result'];
    _riskContent = json['riskContent'];
    _rectHave = json['rectHave'];
    _rectContent = json['rectContent'];
    _rectUserName = json['rectUserName'];
    _rectTime = json['rectTime'];
    _sort = json['sort'];
  }

  String? _id;
  String? _createDate;
  String? _updateDate;
  TaskMonth? _taskMonth;
  DeviceRisk? _deviceRisk;
  DeviceRiskParent? _deviceRiskParent;
  String? _name;
  String? _result;
  String? _riskContent;
  String? _rectHave;
  String? _rectContent;
  String? _rectUserName;
  String? _rectTime;
  int? _sort;
  String? _hiddenText = '去整改';
  String? _hiddenContent = '';
  String? _hiddenName = StorageUtil.getInstance().getName();

  TaskMonthCheck copyWith({
    String? id,
    String? createDate,
    String? updateDate,
    TaskMonth? taskMonth,
    DeviceRisk? deviceRisk,
    DeviceRiskParent? deviceRiskParent,
    String? name,
    String? result,
    String? riskContent,
    String? rectHave,
    String? rectContent,
    String? rectUserName,
    String? rectTime,
    int? sort,
  }) =>
      TaskMonthCheck(
        id: id ?? _id,
        createDate: createDate ?? _createDate,
        updateDate: updateDate ?? _updateDate,
        taskMonth: taskMonth ?? _taskMonth,
        deviceRisk: deviceRisk ?? _deviceRisk,
        deviceRiskParent: deviceRiskParent ?? _deviceRiskParent,
        name: name ?? _name,
        result: result ?? _result,
        riskContent: riskContent ?? _riskContent,
        rectHave: rectHave ?? _rectHave,
        rectContent: rectContent ?? _rectContent,
        rectUserName: rectUserName ?? _rectUserName,
        rectTime: rectTime ?? _rectTime,
        sort: sort ?? _sort,
      );

  String? get id => _id;

  String? get createDate => _createDate;

  String? get updateDate => _updateDate;

  TaskMonth? get taskMonth => _taskMonth;

  DeviceRisk? get deviceRisk => _deviceRisk;

  DeviceRiskParent? get deviceRiskParent => _deviceRiskParent;

  String? get name => _name;

  String? get result => _result;

  String? get riskContent => _riskContent;

  String? get rectHave => _rectHave;

  String? get rectContent => _rectContent;

  String? get rectUserName => _rectUserName;

  String? get rectTime => _rectTime;

  int? get sort => _sort;

  String? get hiddenText => _hiddenText;

  String? get hiddenContent => _hiddenContent;

  String? get hiddenName => _hiddenName;

  set riskContent(String? riskContent) {
    _riskContent = riskContent;
  }

  set hiddenText(String? hiddenText) {
    _hiddenText = hiddenText;
  }

  set hiddenContent(String? hiddenContent) {
    _hiddenContent = hiddenContent;
  }

  // 定义 isChecked 的 setter 方法
  set hiddenName(String? hiddenName) {
    _hiddenName = hiddenName;
  }

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = _id;
    map['createDate'] = _createDate;
    map['updateDate'] = _updateDate;
    if (_taskMonth != null) {
      map['taskMonth'] = _taskMonth?.toJson();
    }
    if (_deviceRisk != null) {
      map['deviceRisk'] = _deviceRisk?.toJson();
    }
    if (_deviceRiskParent != null) {
      map['deviceRiskParent'] = _deviceRiskParent?.toJson();
    }
    map['name'] = _name;
    map['result'] = _result;
    map['riskContent'] = _riskContent;
    map['rectHave'] = _rectHave;
    map['rectContent'] = _rectContent;
    map['rectUserName'] = _rectUserName;
    map['rectTime'] = _rectTime;
    map['sort'] = _sort;
    return map;
  }
}
