import 'package:special_equipment_flutter/model/detail/month/task_month_check_dto_list.dart';

import 'task_month.dart';

/// taskMonth : {"id":"c0186c8e9c1240e98aa8f24cc3162243"}
/// taskMonthCheckDtoList : [{"deviceRisk":{"id":"7a3cd4ca02114e6f81839d5221799901","name":"人员","sort":1,"hasChildren":false,"riskMeasure":"","inspectType":"","isShow":"1","parentId":"0"},"childTaskMonthList":[{"deviceRisk":{"id":"a436d5b2c8924084b46effd4572649c1","parentIds":"0,95b688b736eb486c8204964183e91d56,7a3cd4ca02114e6f81839d5221799901,","name":"作业人员未持有相应资格证件","sort":2,"hasChildren":false,"riskMeasure":"配备具有相应职责资质的作业人员，加强资格证的换证管理","deviceType":{"id":"779d6023cd4148b49288eb3e3616a7e3"},"inspectType":"2","isShow":"1","parentId":"7a3cd4ca02114e6f81839d5221799901"},"sort":2},{"deviceRisk":{"id":"b6dc48e360224039bb16651637129d19","parentIds":"0,95b688b736eb486c8204964183e91d56,7a3cd4ca02114e6f81839d5221799901,","name":"未按规定对安全管理人员和作业人员开展安全教育培训","sort":3,"hasChildren":false,"riskMeasure":"按规定开展安全培训教育","deviceType":{"id":"779d6023cd4148b49288eb3e3616a7e3"},"inspectType":"2","isShow":"1","parentId":"7a3cd4ca02114e6f81839d5221799901"},"sort":3}],"sort":1},{"deviceRisk":{"id":"cabb702f4121446eb509f9bf7b6019c7","name":"管理","sort":2,"hasChildren":false,"riskMeasure":"","inspectType":"","isShow":"1","parentId":"0"},"childTaskMonthList":[{"deviceRisk":{"id":"d0912839b1bb4fb0bc5433d49924d992","parentIds":"0,95b688b736eb486c8204964183e91d56,cabb702f4121446eb509f9bf7b6019c7,","name":"未建立电梯使用安全管理制度","sort":2,"hasChildren":false,"riskMeasure":"1．制定电梯安全管理机构和相关人员岗位职责； 2．制定《电梯安全总监职责》《电梯安全员守则》《电梯安全日管控、周排查、月调度管理制度》； 3.按《特种设备使用管理规则》建立电梯使用安全和节能管理制度 。","deviceType":{"id":"779d6023cd4148b49288eb3e3616a7e3"},"inspectType":"2","isShow":"1","parentId":"cabb702f4121446eb509f9bf7b6019c7"},"sort":2},{"deviceRisk":{"id":"322294d654864bfab0a8522d8324f483","parentIds":"0,95b688b736eb486c8204964183e91d56,cabb702f4121446eb509f9bf7b6019c7,","name":"未建立安全技术档案","sort":3,"hasChildren":false,"riskMeasure":"1.建立电梯安全技术档案管理制度，明确档案内容及管理要求； 2.按规定逐台建立安全技术档案并及时更新安全技术档案。","deviceType":{"id":"779d6023cd4148b49288eb3e3616a7e3"},"inspectType":"2","isShow":"1","parentId":"cabb702f4121446eb509f9bf7b6019c7"},"sort":3},{"deviceRisk":{"id":"88d718342ae8484f99fa51cc64be0261","parentIds":"0,95b688b736eb486c8204964183e91d56,cabb702f4121446eb509f9bf7b6019c7,","name":"未按规定办理使用登记、变更登记及停用、报废等手续","sort":4,"hasChildren":false,"riskMeasure":"1.建立使用管理制度和规程，明确相关内容及安全管理要求； 2. 按规定办理使用登记、变更登记及停用、报废手续。","deviceType":{"id":"779d6023cd4148b49288eb3e3616a7e3"},"inspectType":"2","isShow":"1","parentId":"cabb702f4121446eb509f9bf7b6019c7"},"sort":4}],"sort":2},{"deviceRisk":{"id":"0f6114078a0f47efa7b4e2dc5ead0e48","name":"设备","sort":3,"hasChildren":false,"riskMeasure":"","inspectType":"","isShow":"1","parentId":"0"},"childTaskMonthList":[{"deviceRisk":{"id":"65ea70ca68c746118ff3459f611ea392","parentIds":"0,95b688b736eb486c8204964183e91d56,0f6114078a0f47efa7b4e2dc5ead0e48,","name":"未按有关法律法规、安全技术规范或合同约定进行维护保养；","sort":2,"hasChildren":false,"riskMeasure":"监督维保单位按照《电梯维护保养规则》或合同约定的周期、内容开展电梯维保工作","deviceType":{"id":"779d6023cd4148b49288eb3e3616a7e3"},"inspectType":"2","isShow":"1","parentId":"0f6114078a0f47efa7b4e2dc5ead0e48"},"sort":2}],"sort":3},{"deviceRisk":{"id":"8aadc323437f4290aab7a7d8e8876df9","name":"环境","sort":5,"hasChildren":false,"riskMeasure":"","inspectType":"","isShow":"1","parentId":"0"},"childTaskMonthList":[{"deviceRisk":{"id":"e2991a131d68442aae8488c346489a53","parentIds":"0,95b688b736eb486c8204964183e91d56,8aadc323437f4290aab7a7d8e8876df9,","name":"电梯运行环境存在不符合安全技术规范要求的情况。","sort":1,"hasChildren":false,"riskMeasure":"1.制定电梯巡查制度，设定巡查频次。 2.依据安全技术规范的要求，保证电梯运行环境符合有关要求。","deviceType":{"id":"779d6023cd4148b49288eb3e3616a7e3"},"inspectType":"2","isShow":"1","parentId":"8aadc323437f4290aab7a7d8e8876df9"},"sort":1},{"deviceRisk":{"id":"a10200496d41420b91c86edfe1460dcb","parentIds":"0,95b688b736eb486c8204964183e91d56,8aadc323437f4290aab7a7d8e8876df9,","name":"电梯使用场所是否在易腐蚀、易燃易爆或人员密集场所；","sort":3,"hasChildren":false,"riskMeasure":"检查本单位电梯是否有处于易腐蚀、易燃易爆或人员密集场所或环境","deviceType":{"id":"779d6023cd4148b49288eb3e3616a7e3"},"inspectType":"2","isShow":"1","parentId":"8aadc323437f4290aab7a7d8e8876df9"},"sort":3}],"sort":5}]

class MonthDetailBo {
  MonthDetailBo({
    TaskMonth? taskMonth,
    List<TaskMonthCheckDtoList>? taskMonthCheckDtoList,
  }) {
    _taskMonth = taskMonth;
    _taskMonthCheckDtoList = taskMonthCheckDtoList;
  }

  MonthDetailBo.fromJson(dynamic json) {
    _taskMonth = json['taskMonth'] != null
        ? TaskMonth.fromJson(json['taskMonth'])
        : null;
    if (json['taskMonthCheckDtoList'] != null) {
      _taskMonthCheckDtoList = [];
      json['taskMonthCheckDtoList'].forEach((v) {
        _taskMonthCheckDtoList?.add(TaskMonthCheckDtoList.fromJson(v));
      });
    }
  }

  TaskMonth? _taskMonth;
  List<TaskMonthCheckDtoList>? _taskMonthCheckDtoList;

  MonthDetailBo copyWith({
    TaskMonth? taskMonth,
    List<TaskMonthCheckDtoList>? taskMonthCheckDtoList,
  }) =>
      MonthDetailBo(
        taskMonth: taskMonth ?? _taskMonth,
        taskMonthCheckDtoList: taskMonthCheckDtoList ?? _taskMonthCheckDtoList,
      );

  TaskMonth? get taskMonth => _taskMonth;

  List<TaskMonthCheckDtoList>? get taskMonthCheckDtoList =>
      _taskMonthCheckDtoList;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (_taskMonth != null) {
      map['taskMonth'] = _taskMonth?.toJson();
    }
    if (_taskMonthCheckDtoList != null) {
      map['taskMonthCheckDtoList'] =
          _taskMonthCheckDtoList?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}
