import 'package:special_equipment_flutter/model/detail/month/task_month_check.dart';

import '../device_risk.dart';

/// deviceRisk : {"id":"a436d5b2c8924084b46effd4572649c1","parentIds":"0,95b688b736eb486c8204964183e91d56,7a3cd4ca02114e6f81839d5221799901,","name":"作业人员未持有相应资格证件","sort":2,"hasChildren":false,"riskMeasure":"配备具有相应职责资质的作业人员，加强资格证的换证管理","deviceType":{"id":"779d6023cd4148b49288eb3e3616a7e3"},"inspectType":"2","isShow":"1","parentId":"7a3cd4ca02114e6f81839d5221799901"}
/// sort : 2

class ChildTaskMonthList {
  ChildTaskMonthList({
    DeviceRisk? deviceRisk,
    int? sort,
    TaskMonthCheck? taskMonthCheck,
  }) {
    _deviceRisk = deviceRisk;
    _sort = sort;
    _taskMonthCheck = taskMonthCheck;
  }

  ChildTaskMonthList.fromJson(dynamic json) {
    _deviceRisk = json['deviceRisk'] != null
        ? DeviceRisk.fromJson(json['deviceRisk'])
        : null;
    _sort = json['sort'];
    _taskMonthCheck = json['taskMonthCheck'] != null
        ? TaskMonthCheck.fromJson(json['taskMonthCheck'])
        : null;
  }

  DeviceRisk? _deviceRisk;
  int? _sort;
  TaskMonthCheck? _taskMonthCheck;

  ChildTaskMonthList copyWith({
    DeviceRisk? deviceRisk,
    int? sort,
    TaskMonthCheck? taskMonthCheck,
  }) =>
      ChildTaskMonthList(
        deviceRisk: deviceRisk ?? _deviceRisk,
        sort: sort ?? _sort,
        taskMonthCheck: taskMonthCheck ?? _taskMonthCheck,
      );

  DeviceRisk? get deviceRisk => _deviceRisk;

  int? get sort => _sort;

  TaskMonthCheck? get taskMonthCheck => _taskMonthCheck;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (_deviceRisk != null) {
      map['deviceRisk'] = _deviceRisk?.toJson();
    }
    map['sort'] = _sort;
    if (_taskMonthCheck != null) {
      map['taskMonthCheck'] = _taskMonthCheck?.toJson();
    }
    return map;
  }
}
