import 'package:flutter/material.dart';

import 'device_type.dart';

/// id : "72c680d212d14e1c96a96a424cff1a8b"
/// parentIds : "0,9190984781f44226b984c363bce91663,989bf0708d85409c9e0db505ed94a6fc,"
/// name : "作业人员违章作业或到岗值守情况不符合要求"
/// sort : 4
/// hasChildren : false
/// riskMeasure : "检查锅炉作业人员到岗值守情况，纠正和制止违章作业行为"
/// deviceType : {"id":"99648d6e69c9463d823fac8b7888a240"}
/// inspectType : "1"
/// isShow : "1"
/// parentId : "989bf0708d85409c9e0db505ed94a6fc"

class DeviceRisk {
  DeviceRisk({
    String? id,
    String? parentIds,
    String? name,
    int? sort,
    bool? hasChildren,
    String? riskMeasure,
    DeviceType? deviceType,
    String? inspectType,
    String? isShow,
    String? parentId,
    String? riskcontent,
    String? isChecked,
    bool? isEnabled,
    bool? isCategory,
    FocusNode? focusNode1,
    FocusNode? focusNode2,
  }) {
    _id = id;
    _parentIds = parentIds;
    _name = name;
    _sort = sort;
    _hasChildren = hasChildren;
    _riskMeasure = riskMeasure;
    _deviceType = deviceType;
    _inspectType = inspectType;
    _isShow = isShow;
    _parentId = parentId;

    _riskcontent = riskcontent;
    _isChecked = isChecked;
    _isEnabled = isEnabled;
    _isCategory = isCategory;
    _focusNode1 = focusNode1;
    _focusNode2 = focusNode2;
  }

  DeviceRisk.fromJson(dynamic json) {
    _id = json['id'];
    _parentIds = json['parentIds'];
    _name = json['name'];
    _sort = json['sort'];
    _hasChildren = json['hasChildren'];
    _riskMeasure = json['riskMeasure'];
    _deviceType = json['deviceType'] != null
        ? DeviceType.fromJson(json['deviceType'])
        : null;
    _inspectType = json['inspectType'];
    _isShow = json['isShow'];
    _parentId = json['parentId'];
  }

  String? _id;
  String? _parentIds;
  String? _name;
  int? _sort;
  bool? _hasChildren;
  String? _riskMeasure;
  DeviceType? _deviceType;
  String? _inspectType;
  String? _isShow;
  String? _parentId;
  String? _riskcontent = '';
  String? _isChecked = '1';
  bool? _isEnabled = false;
  bool? _isCategory = false;
  FocusNode? _focusNode1 = FocusNode();
  FocusNode? _focusNode2 = FocusNode();

  DeviceRisk copyWith({
    String? id,
    String? parentIds,
    String? name,
    int? sort,
    bool? hasChildren,
    String? riskMeasure,
    DeviceType? deviceType,
    String? inspectType,
    String? isShow,
    String? parentId,
  }) =>
      DeviceRisk(
        id: id ?? _id,
        parentIds: parentIds ?? _parentIds,
        name: name ?? _name,
        sort: sort ?? _sort,
        hasChildren: hasChildren ?? _hasChildren,
        riskMeasure: riskMeasure ?? _riskMeasure,
        deviceType: deviceType ?? _deviceType,
        inspectType: inspectType ?? _inspectType,
        isShow: isShow ?? _isShow,
        parentId: parentId ?? _parentId,
      );

  String? get parentIds => _parentIds;

  String? get name => _name;

  int? get sort => _sort;

  bool? get hasChildren => _hasChildren;

  String? get riskMeasure => _riskMeasure;

  DeviceType? get deviceType => _deviceType;

  String? get inspectType => _inspectType;

  String? get isShow => _isShow;

  String? get parentId => _parentId;

  String? get id => _id;

  String? get riskcontent => _riskcontent;

  String? get isChecked => _isChecked;

  bool? get isEnabled => _isEnabled;

  bool? get isCategory => _isCategory;

  FocusNode? get focusNode1 => _focusNode1;

  FocusNode? get focusNode2 => _focusNode2;

// 定义 isChecked 的 setter 方法
  set isChecked(String? isChecked) {
    _isChecked = isChecked;
  }

  set riskcontent(String? riskcontent) {
    _riskcontent = riskcontent;
  }

  set name(String? name) {
    _name = name;
  }

  set id(String? id) {
    _id = id;
  }

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = _id;
    map['parentIds'] = _parentIds;
    map['name'] = _name;
    map['sort'] = _sort;
    map['hasChildren'] = _hasChildren;
    map['riskMeasure'] = _riskMeasure;
    if (_deviceType != null) {
      map['deviceType'] = _deviceType?.toJson();
    }
    map['inspectType'] = _inspectType;
    map['isShow'] = _isShow;
    map['parentId'] = _parentId;
    return map;
  }
}
