import '../device_risk.dart';
import 'child_task_day_list.dart';

/// deviceRisk : {"id":"989bf0708d85409c9e0db505ed94a6fc","name":"人员","sort":30,"hasChildren":false,"riskMeasure":"","isShow":"1","parentId":"0"}
/// childTaskDayList : [{"deviceRisk":{"id":"72c680d212d14e1c96a96a424cff1a8b","name":"作业人员违章作业或到岗值守情况不符合要求","sort":30,"hasChildren":false,"riskMeasure":"检查锅炉作业人员到岗值守情况，纠正和制止违章作业行为","isShow":"1","parentId":"0"},"sort":4,"taskDayCheck":{"id":"2935e18338bf4fdca541af7bfb6b4366","createBy":{"id":"8affd75130794659956ce53b7de3a299","loginFlag":"1","roleNames":"","admin":false},"createDate":"2023-10-21 11:48:46","updateBy":{"id":"8affd75130794659956ce53b7de3a299","loginFlag":"1","roleNames":"","admin":false},"updateDate":"2023-10-21 11:48:46","taskDay":{"id":"b212b0f3bb5b4e3088382cd70e4453a7"},"deviceRisk":{"id":"72c680d212d14e1c96a96a424cff1a8b","name":"作业人员违章作业或到岗值守情况不符合要求","sort":30,"hasChildren":false,"riskMeasure":"检查锅炉作业人员到岗值守情况，纠正和制止违章作业行为","isShow":"1","parentId":"0"},"deviceRiskParent":{"id":"989bf0708d85409c9e0db505ed94a6fc","name":"人员","sort":30,"hasChildren":false,"riskMeasure":"","isShow":"1","parentId":"0"},"name":"作业人员违章作业或到岗值守情况不符合要求","result":"1","rectHave":"","rectContent":"","rectUserName":"","rectTime":"","sort":4}}]
/// sort : 30

class TaskDayCheckLists {
  TaskDayCheckLists({
    DeviceRisk? deviceRisk,
    List<ChildTaskDayList>? childTaskDayList,
    int? sort,
  }) {
    _deviceRisk = deviceRisk;
    _childTaskDayList = childTaskDayList;
    _sort = sort;
  }

  TaskDayCheckLists.fromJson(dynamic json) {
    _deviceRisk = json['deviceRisk'] != null
        ? DeviceRisk.fromJson(json['deviceRisk'])
        : null;
    if (json['childTaskDayList'] != null) {
      _childTaskDayList = [];
      json['childTaskDayList'].forEach((v) {
        _childTaskDayList?.add(ChildTaskDayList.fromJson(v));
      });
    }
    _sort = json['sort'];
  }

  DeviceRisk? _deviceRisk;
  List<ChildTaskDayList>? _childTaskDayList;
  int? _sort;

  TaskDayCheckLists copyWith({
    DeviceRisk? deviceRisk,
    List<ChildTaskDayList>? childTaskDayList,
    int? sort,
  }) =>
      TaskDayCheckLists(
        deviceRisk: deviceRisk ?? _deviceRisk,
        childTaskDayList: childTaskDayList ?? _childTaskDayList,
        sort: sort ?? _sort,
      );

  DeviceRisk? get deviceRisk => _deviceRisk;

  List<ChildTaskDayList>? get childTaskDayList => _childTaskDayList;

  int? get sort => _sort;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (_deviceRisk != null) {
      map['deviceRisk'] = _deviceRisk?.toJson();
    }
    if (_childTaskDayList != null) {
      map['childTaskDayList'] =
          _childTaskDayList?.map((v) => v.toJson()).toList();
    }
    map['sort'] = _sort;
    return map;
  }
}
