import 'package:special_equipment_flutter/model/detail/day/task_day.dart';
import 'package:special_equipment_flutter/utils/storage_util.dart';

import '../device_risk.dart';
import '../device_risk_parent.dart';

/// id : "2935e18338bf4fdca541af7bfb6b4366"
/// createBy : {"id":"8affd75130794659956ce53b7de3a299","loginFlag":"1","roleNames":"","admin":false}
/// createDate : "2023-10-21 11:48:46"
/// updateBy : {"id":"8affd75130794659956ce53b7de3a299","loginFlag":"1","roleNames":"","admin":false}
/// updateDate : "2023-10-21 11:48:46"
/// taskDay : {"id":"b212b0f3bb5b4e3088382cd70e4453a7"}
/// deviceRisk : {"id":"72c680d212d14e1c96a96a424cff1a8b","name":"作业人员违章作业或到岗值守情况不符合要求","sort":30,"hasChildren":false,"riskMeasure":"检查锅炉作业人员到岗值守情况，纠正和制止违章作业行为","isShow":"1","parentId":"0"}
/// deviceRiskParent : {"id":"989bf0708d85409c9e0db505ed94a6fc","name":"人员","sort":30,"hasChildren":false,"riskMeasure":"","isShow":"1","parentId":"0"}
/// name : "作业人员违章作业或到岗值守情况不符合要求"
/// result : "1"
/// rectHave : ""
/// rectContent : ""
/// rectUserName : ""
/// rectTime : ""
/// sort : 4

class TaskDayCheck {
  TaskDayCheck({
    String? id,
    String? createDate,
    String? updateDate,
    TaskDay? taskDay,
    DeviceRisk? deviceRisk,
    DeviceRiskParent? deviceRiskParent,
    String? name,
    String? riskContent,
    String? result,
    String? rectHave,
    String? rectContent,
    String? rectUserName,
    String? rectTime,
    int? sort,
    String? hiddenText,
    String? hiddenName,
    String? hiddenContent,
  }) {
    _id = id;
    _createDate = createDate;
    _updateDate = updateDate;
    _taskDay = taskDay;
    _deviceRisk = deviceRisk;
    _deviceRiskParent = deviceRiskParent;
    _name = name;
    _result = result;
    _riskContent = riskContent;
    _rectHave = rectHave;
    _rectContent = rectContent;
    _rectUserName = rectUserName;
    _rectTime = rectTime;
    _sort = sort;
    _hiddenText = hiddenText;
    _hiddenName = hiddenName;
    _hiddenContent = hiddenContent;
  }

  TaskDayCheck.fromJson(dynamic json) {
    _id = json['id'];
    _createDate = json['createDate'];
    _updateDate = json['updateDate'];
    _taskDay =
        json['taskDay'] != null ? TaskDay.fromJson(json['taskDay']) : null;
    _deviceRisk = json['deviceRisk'] != null
        ? DeviceRisk.fromJson(json['deviceRisk'])
        : null;
    _deviceRiskParent = json['deviceRiskParent'] != null
        ? DeviceRiskParent.fromJson(json['deviceRiskParent'])
        : null;
    _name = json['name'];
    _result = json['result'];
    _riskContent = json['riskContent'];
    _rectHave = json['rectHave'];
    _rectContent = json['rectContent'];
    _rectUserName = json['rectUserName'];
    _rectTime = json['rectTime'];
    _sort = json['sort'];
  }

  String? _id;
  String? _createDate;
  String? _updateDate;
  TaskDay? _taskDay;
  DeviceRisk? _deviceRisk;
  DeviceRiskParent? _deviceRiskParent;
  String? _name;
  String? _result;
  String? _riskContent;
  String? _rectHave;
  String? _rectContent;
  String? _rectUserName;
  String? _rectTime;
  int? _sort;
  String? _hiddenText = '去整改';
  String? _hiddenContent = '';
  String? _hiddenName = StorageUtil.getInstance().getName();

  TaskDayCheck copyWith({
    String? id,
    String? createDate,
    String? updateDate,
    TaskDay? taskDay,
    DeviceRisk? deviceRisk,
    DeviceRiskParent? deviceRiskParent,
    String? name,
    String? result,
    String? riskContent,
    String? rectHave,
    String? rectContent,
    String? rectUserName,
    String? rectTime,
    int? sort,
  }) =>
      TaskDayCheck(
        id: id ?? _id,
        createDate: createDate ?? _createDate,
        updateDate: updateDate ?? _updateDate,
        taskDay: taskDay ?? _taskDay,
        deviceRisk: deviceRisk ?? _deviceRisk,
        deviceRiskParent: deviceRiskParent ?? _deviceRiskParent,
        name: name ?? _name,
        result: result ?? _result,
        rectHave: rectHave ?? _rectHave,
        riskContent: riskContent ?? _riskContent,
        rectContent: rectContent ?? _rectContent,
        rectUserName: rectUserName ?? _rectUserName,
        rectTime: rectTime ?? _rectTime,
        sort: sort ?? _sort,
      );

  String? get id => _id;

  String? get createDate => _createDate;

  String? get updateDate => _updateDate;

  TaskDay? get taskDay => _taskDay;

  DeviceRisk? get deviceRisk => _deviceRisk;

  DeviceRiskParent? get deviceRiskParent => _deviceRiskParent;

  String? get name => _name;

  String? get result => _result;

  String? get rectHave => _rectHave;

  String? get riskContent => _riskContent;

  String? get rectContent => _rectContent;

  String? get rectUserName => _rectUserName;

  String? get rectTime => _rectTime;

  int? get sort => _sort;

  String? get hiddenText => _hiddenText;

  String? get hiddenContent => _hiddenContent;

  String? get hiddenName => _hiddenName;

  set riskContent(String? riskContent) {
    _riskContent = riskContent;
  }

  set hiddenText(String? hiddenText) {
    _hiddenText = hiddenText;
  }

  set hiddenContent(String? hiddenContent) {
    _hiddenContent = hiddenContent;
  }

  // 定义 isChecked 的 setter 方法
  set hiddenName(String? hiddenName) {
    _hiddenName = hiddenName;
  }

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = _id;
    map['createDate'] = _createDate;
    map['updateDate'] = _updateDate;
    if (_taskDay != null) {
      map['taskDay'] = _taskDay?.toJson();
    }
    if (_deviceRisk != null) {
      map['deviceRisk'] = _deviceRisk?.toJson();
    }
    if (_deviceRiskParent != null) {
      map['deviceRiskParent'] = _deviceRiskParent?.toJson();
    }
    map['name'] = _name;
    map['result'] = _result;
    map['rectHave'] = _rectHave;
    map['riskContent'] = _riskContent;
    map['rectContent'] = _rectContent;
    map['rectUserName'] = _rectUserName;
    map['rectTime'] = _rectTime;
    map['sort'] = _sort;
    return map;
  }
}
