import 'package:special_equipment_flutter/model/detail/day/task_day.dart';

import 'task_day_check_list.dart';

class DayDetailBo {
  DayDetailBo({
    TaskDay? taskDay,
    List<TaskDayCheckLists>? taskDayCheckList,
  }) {
    _taskDay = taskDay;
    _taskDayCheckList = taskDayCheckList;
  }

  DayDetailBo.fromJson(dynamic json) {
    _taskDay =
        json['taskDay'] != null ? TaskDay.fromJson(json['taskDay']) : null;
    if (json['taskDayCheckList'] != null) {
      _taskDayCheckList = [];
      json['taskDayCheckList'].forEach((v) {
        _taskDayCheckList?.add(TaskDayCheckLists.fromJson(v));
      });
    }
  }

  TaskDay? _taskDay;
  List<TaskDayCheckLists>? _taskDayCheckList;

  DayDetailBo copyWith({
    TaskDay? taskDay,
    List<TaskDayCheckLists>? taskDayCheckList,
  }) =>
      DayDetailBo(
        taskDay: taskDay ?? _taskDay,
        taskDayCheckList: taskDayCheckList ?? _taskDayCheckList,
      );

  TaskDay? get taskDay => _taskDay;

  List<TaskDayCheckLists>? get taskDayCheckList => _taskDayCheckList;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (_taskDay != null) {
      map['taskDay'] = _taskDay?.toJson();
    }
    if (_taskDayCheckList != null) {
      map['taskDayCheckList'] =
          _taskDayCheckList?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}
