import 'package:special_equipment_flutter/model/detail/day/task_day_check.dart';

import '../device_risk.dart';

/// deviceRisk : {"id":"72c680d212d14e1c96a96a424cff1a8b","name":"作业人员违章作业或到岗值守情况不符合要求","sort":30,"hasChildren":false,"riskMeasure":"检查锅炉作业人员到岗值守情况，纠正和制止违章作业行为","isShow":"1","parentId":"0"}
/// sort : 4
/// taskDayCheck : {"id":"2935e18338bf4fdca541af7bfb6b4366","createBy":{"id":"8affd75130794659956ce53b7de3a299","loginFlag":"1","roleNames":"","admin":false},"createDate":"2023-10-21 11:48:46","updateBy":{"id":"8affd75130794659956ce53b7de3a299","loginFlag":"1","roleNames":"","admin":false},"updateDate":"2023-10-21 11:48:46","taskDay":{"id":"b212b0f3bb5b4e3088382cd70e4453a7"},"deviceRisk":{"id":"72c680d212d14e1c96a96a424cff1a8b","name":"作业人员违章作业或到岗值守情况不符合要求","sort":30,"hasChildren":false,"riskMeasure":"检查锅炉作业人员到岗值守情况，纠正和制止违章作业行为","isShow":"1","parentId":"0"},"deviceRiskParent":{"id":"989bf0708d85409c9e0db505ed94a6fc","name":"人员","sort":30,"hasChildren":false,"riskMeasure":"","isShow":"1","parentId":"0"},"name":"作业人员违章作业或到岗值守情况不符合要求","result":"1","rectHave":"","rectContent":"","rectUserName":"","rectTime":"","sort":4}

class ChildTaskDayList {
  ChildTaskDayList({
    DeviceRisk? deviceRisk,
    int? sort,
    TaskDayCheck? taskDayCheck,
  }) {
    _deviceRisk = deviceRisk;
    _sort = sort;
    _taskDayCheck = taskDayCheck;
  }

  ChildTaskDayList.fromJson(dynamic json) {
    _deviceRisk = json['deviceRisk'] != null
        ? DeviceRisk.fromJson(json['deviceRisk'])
        : null;
    _sort = json['sort'];
    _taskDayCheck = json['taskDayCheck'] != null
        ? TaskDayCheck.fromJson(json['taskDayCheck'])
        : null;
  }

  DeviceRisk? _deviceRisk;
  int? _sort;
  TaskDayCheck? _taskDayCheck;

  ChildTaskDayList copyWith({
    DeviceRisk? deviceRisk,
    int? sort,
    TaskDayCheck? taskDayCheck,
  }) =>
      ChildTaskDayList(
        deviceRisk: deviceRisk ?? _deviceRisk,
        sort: sort ?? _sort,
        taskDayCheck: taskDayCheck ?? _taskDayCheck,
      );

  DeviceRisk? get deviceRisk => _deviceRisk;

  int? get sort => _sort;

  TaskDayCheck? get taskDayCheck => _taskDayCheck;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (_deviceRisk != null) {
      map['deviceRisk'] = _deviceRisk?.toJson();
    }
    map['sort'] = _sort;
    if (_taskDayCheck != null) {
      map['taskDayCheck'] = _taskDayCheck?.toJson();
    }
    return map;
  }
}
