class DaySubmitBo {
  DaySubmitBo({
    required this.id,
    required this.result,
    required this.checkTime,
    required this.taskState,
    required this.prictures,
    required this.checkUser,
    required this.taskDayCheckList,
  });

  late final String id;
  late final String result;
  late final String checkTime;
  late final String taskState;
  late final String prictures;
  late final CheckUser checkUser;
  late final List<TaskDayCheckSubmitList> taskDayCheckList;

  DaySubmitBo.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    result = json['result'];
    checkTime = json['checkTime'];
    taskState = json['taskState'];
    prictures = json['prictures'];
    checkUser = CheckUser.fromJson(json['checkUser']);
    taskDayCheckList = List.from(json['taskDayCheckList'])
        .map((e) => TaskDayCheckSubmitList.fromJson(e))
        .toList();
  }

  Map<String, dynamic> toJson() {
    final _data = <String, dynamic>{};
    _data['id'] = id;
    _data['result'] = result;
    _data['checkTime'] = checkTime;
    _data['taskState'] = taskState;
    _data['prictures'] = prictures;
    _data['checkUser'] = checkUser.toJson();
    _data['taskDayCheckList'] =
        taskDayCheckList.map((e) => e.toJson()).toList();
    return _data;
  }
}

class CheckUser {
  CheckUser({
    required this.id,
  });

  late final String id;

  CheckUser.fromJson(Map<String, dynamic> json) {
    id = json['id'];
  }

  Map<String, dynamic> toJson() {
    final _data = <String, dynamic>{};
    _data['id'] = id;
    return _data;
  }
}

class TaskDayCheckSubmitList {
  TaskDayCheckSubmitList({
    required this.id,
    required this.name,
    required this.result,
    required this.sort,
    required this.riskContent,
    required this.taskDay,
    required this.deviceRiskParent,
    required this.deviceRisk,
    required this.rectHave,
    required this.rectContent,
    required this.rectUserName,
    required this.rectTime,
  });

  late final String id;
  late final String name;
  late final String result;
  late final int sort;
  late final String riskContent;
  late final String rectHave;
  late final String rectContent;
  late final String rectUserName;
  late final String rectTime;
  late final TaskDays taskDay;
  late final DeviceRiskParents deviceRiskParent;
  late final DeviceRisks deviceRisk;

  TaskDayCheckSubmitList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    result = json['result'];
    sort = json['sort'];
    riskContent = json['riskContent'];
    rectHave = json['rectHave'];
    rectContent = json['rectContent'];
    rectUserName = json['rectUserName'];
    rectTime = json['rectTime'];
    taskDay = TaskDays.fromJson(json['taskDay']);
    deviceRiskParent = DeviceRiskParents.fromJson(json['deviceRiskParent']);
    deviceRisk = DeviceRisks.fromJson(json['deviceRisk']);
  }

  Map<String, dynamic> toJson() {
    final _data = <String, dynamic>{};
    _data['id'] = id;
    _data['name'] = name;
    _data['result'] = result;
    _data['sort'] = sort;
    _data['riskContent'] = riskContent;
    _data['rectHave'] = rectHave;
    _data['rectContent'] = rectContent;
    _data['rectUserName'] = rectUserName;
    _data['rectTime'] = rectTime;
    _data['taskDay'] = taskDay.toJson();
    _data['deviceRiskParent'] = deviceRiskParent.toJson();
    _data['deviceRisk'] = deviceRisk.toJson();
    return _data;
  }
}

class TaskDays {
  TaskDays({
    required this.id,
  });

  late final String id;

  TaskDays.fromJson(Map<String, dynamic> json) {
    id = json['id'];
  }

  Map<String, dynamic> toJson() {
    final _data = <String, dynamic>{};
    _data['id'] = id;
    return _data;
  }
}

class DeviceRiskParents {
  DeviceRiskParents({
    required this.id,
  });

  late final String id;

  DeviceRiskParents.fromJson(Map<String, dynamic> json) {
    id = json['id'];
  }

  Map<String, dynamic> toJson() {
    final _data = <String, dynamic>{};
    _data['id'] = id;
    return _data;
  }
}

class DeviceRisks {
  DeviceRisks({
    required this.id,
  });

  late final String id;

  DeviceRisks.fromJson(Map<String, dynamic> json) {
    id = json['id'];
  }

  Map<String, dynamic> toJson() {
    final _data = <String, dynamic>{};
    _data['id'] = id;
    return _data;
  }
}
