class ResultObjBo<T> {
  bool? success;
  String? errorCode;
  String? msg;
  T? body;

  ResultObjBo({
    this.msg,
    this.errorCode,
    this.body,
  });

  ResultObjBo.fromJson(
      Map<String, dynamic> json, T Function(dynamic json) fromJsonT) {
    success = json['success'];
    msg = json['msg'];
    errorCode = json['errorCode'];
    body = json['body'] != null
        ? fromJsonT(json['body'] as Map<String, dynamic>)
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['success'] = this.success;
    data['errorCode'] = this.errorCode;
    data['msg'] = this.msg;
    data['body'] = this.body;
    return data;
  }
}
