class ResultListBo<T> {
  bool? success;
  String? errorCode;
  String? msg;
  List<T>? body;

  ResultListBo({
    this.success,
    this.errorCode,
    this.msg,
    this.body,
  });

  ResultListBo.fromJson(
      Map<String, dynamic> json, T Function(dynamic json) fromJsonT) {
    success = json['success'];
    errorCode = json['errorCode'];
    msg = json['msg'];
    body = json['body'] != null
        ? (json['body'] as List<dynamic>).map((e) => fromJsonT(e)).toList()
        : null;
  }
}
