import 'package:special_equipment_flutter/dio/entity_factory.dart';

///拿到服务器数据后，我们希望转换成自己方便使用的model结构
///API统一返回格式 返回json 'T'为对象
class BaseModel<T> {
  bool? success;
  String? errorCode;
  String? msg;
  T? body;

  BaseModel({this.success, this.errorCode, this.msg, this.body});

  factory BaseModel.fromJson(json) {
    ///获取接口数据
    if (json["body"] != null) {
      return BaseModel(
        success: json["success"],
        errorCode: json["errorCode"],
        msg: json["msg"],
        // data值需要经过工厂转换为我们传进来的类型
        body: EntityFactory.generateOBJ<T>(json["body"]),
      );
    } else {
      return BaseModel(
          success: json["success"],
          errorCode: json["errorCode"],
          msg: json["msg"],
          body: null);
    }
  }
}

class BaseModels<T> {
  bool? success;
  String? errorCode;
  String? msg;

  BaseModels({this.success, this.errorCode, this.msg});

  factory BaseModels.fromJson(json) {
    return BaseModels(
        success: json["success"],
        errorCode: json["errorCode"],
        msg: json["msg"]);
  }
}
