class BannerListBo {
  BannerListBo({
    this.data,
  });

  BannerListBo.fromJson(dynamic json) {
    if (json['data'] != null) {
      data = [];
      json['data'].forEach((v) {
        data?.add(Data.fromJson(v));
      });
    }
  }

  List<Data>? data;

  BannerListBo copyWith({
    List<Data>? data,
  }) =>
      BannerListBo(
        data: data ?? this.data,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (data != null) {
      map['data'] = data?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}

class Data {
  Data({
    this.id,
    this.remarks,
    this.createBy,
    this.createDate,
    this.updateBy,
    this.updateDate,
    this.businessName,
    this.advertisUrl,
    this.advertisPosition,
    this.linkUrl,
    this.isShow,
  });

  Data.fromJson(dynamic json) {
    id = json['id'];
    remarks = json['remarks'];
    createBy =
        json['createBy'] != null ? CreateBy.fromJson(json['createBy']) : null;
    createDate = json['createDate'];
    updateBy =
        json['updateBy'] != null ? UpdateBy.fromJson(json['updateBy']) : null;
    updateDate = json['updateDate'];
    businessName = json['businessName'];
    advertisUrl = json['advertisUrl'];
    advertisPosition = json['advertisPosition'];
    linkUrl = json['linkUrl'];
    isShow = json['isShow'];
  }

  String? id;
  String? remarks;
  CreateBy? createBy;
  String? createDate;
  UpdateBy? updateBy;
  String? updateDate;
  String? businessName;
  String? advertisUrl;
  String? advertisPosition;
  String? linkUrl;
  String? isShow;

  Data copyWith({
    String? id,
    String? remarks,
    CreateBy? createBy,
    String? createDate,
    UpdateBy? updateBy,
    String? updateDate,
    String? businessName,
    String? advertisUrl,
    String? advertisPosition,
    String? linkUrl,
    String? isShow,
  }) =>
      Data(
        id: id ?? this.id,
        remarks: remarks ?? this.remarks,
        createBy: createBy ?? this.createBy,
        createDate: createDate ?? this.createDate,
        updateBy: updateBy ?? this.updateBy,
        updateDate: updateDate ?? this.updateDate,
        businessName: businessName ?? this.businessName,
        advertisUrl: advertisUrl ?? this.advertisUrl,
        advertisPosition: advertisPosition ?? this.advertisPosition,
        linkUrl: linkUrl ?? this.linkUrl,
        isShow: isShow ?? this.isShow,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['remarks'] = remarks;
    if (createBy != null) {
      map['createBy'] = createBy?.toJson();
    }
    map['createDate'] = createDate;
    if (updateBy != null) {
      map['updateBy'] = updateBy?.toJson();
    }
    map['updateDate'] = updateDate;
    map['businessName'] = businessName;
    map['advertisUrl'] = advertisUrl;
    map['advertisPosition'] = advertisPosition;
    map['linkUrl'] = linkUrl;
    map['isShow'] = isShow;
    return map;
  }
}

class UpdateBy {
  UpdateBy({
    this.id,
    this.loginFlag,
    this.roleNames,
    this.admin,
  });

  UpdateBy.fromJson(dynamic json) {
    id = json['id'];
    loginFlag = json['loginFlag'];
    roleNames = json['roleNames'];
    admin = json['admin'];
  }

  String? id;
  String? loginFlag;
  String? roleNames;
  bool? admin;

  UpdateBy copyWith({
    String? id,
    String? loginFlag,
    String? roleNames,
    bool? admin,
  }) =>
      UpdateBy(
        id: id ?? this.id,
        loginFlag: loginFlag ?? this.loginFlag,
        roleNames: roleNames ?? this.roleNames,
        admin: admin ?? this.admin,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['loginFlag'] = loginFlag;
    map['roleNames'] = roleNames;
    map['admin'] = admin;
    return map;
  }
}

class CreateBy {
  CreateBy({
    this.id,
    this.loginFlag,
    this.roleNames,
    this.admin,
  });

  CreateBy.fromJson(dynamic json) {
    id = json['id'];
    loginFlag = json['loginFlag'];
    roleNames = json['roleNames'];
    admin = json['admin'];
  }

  String? id;
  String? loginFlag;
  String? roleNames;
  bool? admin;

  CreateBy copyWith({
    String? id,
    String? loginFlag,
    String? roleNames,
    bool? admin,
  }) =>
      CreateBy(
        id: id ?? this.id,
        loginFlag: loginFlag ?? this.loginFlag,
        roleNames: roleNames ?? this.roleNames,
        admin: admin ?? this.admin,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['loginFlag'] = loginFlag;
    map['roleNames'] = roleNames;
    map['admin'] = admin;
    return map;
  }
}
