class AppRoles {
  AppRoles({
    this.data,
  });

  AppRoles.fromJson(dynamic json) {
    if (json['data'] != null) {
      data = [];
      json['data'].forEach((v) {
        data?.add(Data.fromJson(v));
      });
    }
  }

  List<Data>? data;

  AppRoles copyWith({
    List<Data>? data,
  }) =>
      AppRoles(
        data: data ?? this.data,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (data != null) {
      map['data'] = data?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}

class Data {
  Data({
    this.roleId,
    this.name,
    this.userDtoList,
    this.check,
  });

  Data.fromJson(dynamic json) {
    roleId = json['roleId'];
    name = json['name'];
    if (json['userDtoList'] != null) {
      userDtoList = [];
      json['userDtoList'].forEach((v) {
        userDtoList?.add(UserNewDtoList.fromJson(v));
      });
    }
    check = json['check'];
  }

  String? roleId;
  String? name;
  List<UserNewDtoList>? userDtoList=[];
  bool? check;

  Data copyWith({
    String? roleId,
    String? name,
    List<UserNewDtoList>? userDtoList,
    bool? check,
  }) =>
      Data(
        roleId: roleId ?? this.roleId,
        name: name ?? this.name,
        userDtoList: userDtoList ?? this.userDtoList,
        check: check ?? this.check,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['roleId'] = roleId;
    map['name'] = name;
    if (userDtoList != null) {
      map['userDtoList'] = userDtoList?.map((v) => v.toJson()).toList();
    }
    map['check'] = check;
    return map;
  }
}

class UserNewDtoList {
  UserNewDtoList({
    this.deviceTypeId,
    this.unitType,
    this.name,
    this.sort,
    this.check,
  });

  UserNewDtoList.fromJson(dynamic json) {
    deviceTypeId = json['deviceTypeId'];
    unitType = json['unitType'];
    name = json['name'];
    sort = json['sort'];
    check = json['check'];
  }

  String? deviceTypeId;
  String? unitType;
  String? name;
  String? sort;
  bool? check;

  UserNewDtoList copyWith({
    String? deviceTypeId,
    String? unitType,
    String? name,
    String? sort,
    bool? check,
  }) =>
      UserNewDtoList(
        deviceTypeId: deviceTypeId ?? this.deviceTypeId,
        unitType: unitType ?? this.unitType,
        name: name ?? this.name,
        sort: sort ?? this.sort,
        check: check ?? this.check,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['deviceTypeId'] = deviceTypeId;
    map['unitType'] = unitType;
    map['name'] = name;
    map['sort'] = sort;
    map['check'] = check;
    return map;
  }
}
