// ignore_for_file: use_build_context_synchronously, unnecessary_null_comparison, prefer_typing_uninitialized_variables

import 'dart:developer';

import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'package:get/route_manager.dart';
import 'package:special_equipment_flutter/dio/dio/do_utils.dart';
import 'package:special_equipment_flutter/model/app_is_open.dart';
import 'package:special_equipment_flutter/model/app_roles.dart';
import 'package:special_equipment_flutter/model/banner_list_bo.dart';
import 'package:special_equipment_flutter/model/base/base_model.dart';
import 'package:special_equipment_flutter/model/base/result_obj_bo.dart';
import 'package:special_equipment_flutter/model/city_address_bo.dart';
import 'package:special_equipment_flutter/model/completed_list_bo.dart';
import 'package:special_equipment_flutter/model/count_bo.dart';
import 'package:special_equipment_flutter/model/day_control_list_sy_bo.dart';
import 'package:special_equipment_flutter/model/detail/day/day_detail_bo.dart';
import 'package:special_equipment_flutter/model/detail/month/month_detail_bo.dart';
import 'package:special_equipment_flutter/model/detail/week/week_detail_bo.dart';
import 'package:special_equipment_flutter/model/device_list_bo.dart';
import 'package:special_equipment_flutter/model/echart_bo.dart';
import 'package:special_equipment_flutter/model/equipment_bo.dart';
import 'package:special_equipment_flutter/model/exam/eq_question_bo.dart';
import 'package:special_equipment_flutter/model/exam/equipment_list_bo.dart';
import 'package:special_equipment_flutter/model/exam/exam_result_bo.dart';
import 'package:special_equipment_flutter/model/exam/exam_unit_list.dart';
import 'package:special_equipment_flutter/model/exam/examine_person_bo.dart';
import 'package:special_equipment_flutter/model/exam/examine_questions_bo.dart';
import 'package:special_equipment_flutter/model/exam/find_question_num.dart';
import 'package:special_equipment_flutter/model/exam/overseer_history_details_bo.dart';
import 'package:special_equipment_flutter/model/exam/overseer_history_information_bo.dart';
import 'package:special_equipment_flutter/model/exam/overseer_history_list_bo.dart';
import 'package:special_equipment_flutter/model/exam/show_answer_bo.dart';
import 'package:special_equipment_flutter/model/exam/test_questions_bo.dart';
import 'package:special_equipment_flutter/model/exam/unit_person_list_bo.dart';
import 'package:special_equipment_flutter/model/find_charge_list_bo.dart';
import 'package:special_equipment_flutter/model/find_count_bo.dart';
import 'package:special_equipment_flutter/model/login_bo.dart';
import 'package:special_equipment_flutter/model/month_control_list_sy_bo.dart';
import 'package:special_equipment_flutter/model/office_device.dart';
import 'package:special_equipment_flutter/model/role_bo.dart';
import 'package:special_equipment_flutter/model/sy_device_list_bo.dart';
import 'package:special_equipment_flutter/model/system_time.dart';
import 'package:special_equipment_flutter/model/upload_multifile.dart';
import 'package:special_equipment_flutter/model/user_list.dart';
import 'package:special_equipment_flutter/model/week_control_list_sy_bo.dart';
import 'package:special_equipment_flutter/ui/common/data.dart';
import 'package:special_equipment_flutter/utils/eventbus_utils.dart';
import 'package:special_equipment_flutter/utils/storage_util.dart';
import 'package:special_equipment_flutter/utils/toast_utils.dart';

import '../model/version/version_bo.dart';
import 'api.dart';
import 'net_utils.dart';

class HttpUtils {
  /// 登录接口
  static void doLogin(BuildContext context, String userName, String passWord,
      {Function(LoginBo bo)? onSuccess}) {
    Map<String, dynamic> params = {
      'username': userName,
      'password': passWord,
    };
    DoUtils.post(context, Api.LOGIN_URL,
        parameters: params,
        isLoading: true,
        loadingText: '登录中', onSuccess: (Response response) {
      var resultObj =
          ResultObjBo.fromJson(response.data, (json) => LoginBo.fromJson(json));
      LoginBo? bo = resultObj.body;
      onSuccess!(bo!);
    }, onError: (e) {});
  }

  ///登录接口
  // static Future doLogin(
  //     BuildContext context, String userName, String passWord) async {
  //   Map<String, dynamic> params = {
  //     'username': userName,
  //     'password': passWord,
  //   };
  //   var response =
  //       await NetUtils.post(context, Api.LOGIN_URL, true, '登录中', params);
  //   try {
  //     BaseModel entity = BaseModel.fromJson(response);
  //     Map<String, dynamic> resultData = entity.body;
  //     LoginBo loginBo = LoginBo.fromJson(resultData);
  //     if (entity.errorCode == '-1') {
  //       // ToastUtils.showCenter( entity.msg!,gravity: ToastGravity.CENTER,);
  //       return loginBo;
  //     } else {
  //       ToastUtils.showCenter(entity.msg!);
  //       return;
  //     }
  //   } catch (e) {
  //     log(e.toString());
  //     return {"message": e.toString()};
  //   }
  // }

  ///退出接口
  static Future doLoginOut(BuildContext context) async {
    Map<String, dynamic> params = {};
    var response = await NetUtils.get(
        context,
        '${Api.LOGIN_OUT};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        params,
        '正在退出登录...');
    try {
      BaseModel entity = BaseModel.fromJson(response);
      if (entity.errorCode == '-1') {
        return entity;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///获取时间
  static Future doTime(BuildContext context) async {
    Map<String, dynamic> params = {};
    var response = await NetUtils.get(
        context,
        '${Api.GET_SYSTEM_TIME};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      SystemTime systemTime = SystemTime.fromJson(resultData);
      if (entity.errorCode == '-1') {
        return systemTime;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///获取时间
  static Future doCount(BuildContext context, taskState, type) async {
    Map<String, dynamic> params = {
      'delFlag': '0',
      'userids': StorageUtil.getInstance().getUserId(),
      'taskState': taskState,
      'deviceType.unitType': StorageUtil.getInstance().getUnitStatus(),
    };
    var response;
    if (type == '1') {
      response = await NetUtils.get(
          context,
          '${Api.GET_DAY_COUNT};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
          false,
          params);
    } else if (type == '2') {
      response = await NetUtils.get(
          context,
          '${Api.GET_WEEK_COUNT};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
          false,
          params);
    } else if (type == '3') {
      response = await NetUtils.get(
          context,
          '${Api.GET_MONTH_COUNT};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
          false,
          params);
    }
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      CountBo countBo = CountBo.fromJson(resultData);
      if (entity.errorCode == '-1') {
//        ToastUtil.showToastBottom(context, entity.msg!);
        return countBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///首页 日
  static Future doEchartDay(BuildContext context, type) async {
    Map<String, dynamic> params = {
      // 'userids': StorageUtil.getInstance().getUserId(),
      'deviceType.unitType':
          isRolesName1(StorageUtil.getInstance().getRoleNames())
              ? StorageUtil.getInstance().getUnitStatus()
              : '',
      'office.id': StorageUtil.getInstance().getOfficeId(),
    };
    var response;
    if (type == '1') {
      response = await NetUtils.get(
          context,
          '${Api.SEVEN_DAY_COUNT};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
          false,
          params);
    } else if (type == '2') {
      response = await NetUtils.get(
          context,
          '${Api.SEVEN_WEEK_COUNT};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
          false,
          params);
    } else if (type == '3') {
      response = await NetUtils.get(
          context,
          '${Api.SEVEN_MONTH_COUNT};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
          false,
          params);
    }
    try {
      BaseModel entity = BaseModel.fromJson(response);
      EchartBo echartBo = EchartBo.fromJson(entity.body);
      if (entity.errorCode == "-1") {
        return echartBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///使用单位\生产单位-日管控、周排查、月调度已完成列表 分页
  static Future getTaskDayListPage(BuildContext context, taskState, beginTime,
      unitType, pageSize, pageNo) async {
    Map<String, dynamic> params = {
      'delFlag': '0',
      // 'userids': StorageUtil.getInstance().getUserId(),
      'taskState': taskState,
      'beginTime': beginTime,
      'deviceType.unitType': unitType,
      'office.id': StorageUtil.getInstance().getOfficeId(),
      'pageSize': pageSize,
      'pageNo': pageNo
    };
    var response = await NetUtils.get(
        context,
        '${Api.TASK_DAY_LIST_PAGE};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        false,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      CompletedListBo completedListBo = CompletedListBo.fromJson(entity.body);
      if (entity.errorCode == "-1") {
        return completedListBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///使用单位\生产单位-周排查-已完成列表 分页
  static Future getTaskWeekListPage(BuildContext context, taskState, beginTime,
      unitType, pageSize, pageNo) async {
    Map<String, dynamic> params = {
      'delFlag': '0',
      // 'userids': StorageUtil.getInstance().getUserId(),
      'taskState': taskState,
      'beginTime': beginTime,
      'deviceType.unitType': unitType,
      'office.id': StorageUtil.getInstance().getOfficeId(),
      'pageSize': pageSize,
      'pageNo': pageNo
    };
    var response = await NetUtils.get(
        context,
        '${Api.TASK_WEEK_LIST_PAGE};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        false,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      CompletedListBo completedListBo = CompletedListBo.fromJson(entity.body);
      if (entity.errorCode == "-1") {
        return completedListBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///使用单位\生产单位-月调度-已完成列表 分页
  static Future getTaskMonthListPage(BuildContext context, taskState, beginTime,
      unitType, pageSize, pageNo) async {
    Map<String, dynamic> params = {
      'delFlag': '0',
      // 'userids': StorageUtil.getInstance().getUserId(),
      'taskState': taskState,
      'beginTime': beginTime,
      'deviceType.unitType': unitType,
      'office.id': StorageUtil.getInstance().getOfficeId(),
      'pageSize': pageSize,
      'pageNo': pageNo
    };
    var response = await NetUtils.get(
        context,
        '${Api.TASK_MONTH_LIST_PAGE};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        false,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      CompletedListBo completedListBo = CompletedListBo.fromJson(entity.body);
      if (entity.errorCode == "-1") {
        return completedListBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///使用单位-日管控、风险整改列表
  static Future getFindUserAllTaskDayList(
      BuildContext context, taskState, beginTime, unitType) async {
    Map<String, dynamic> params = {
      'delFlag': '0',
      'userids': StorageUtil.getInstance().getUserId(),
      'taskState': taskState,
      'beginTime': beginTime,
      'deviceType.unitType': unitType
    };
    var response = await NetUtils.get(
        context,
        '${Api.FIND_USER_ALLTASK_DAY_LIST};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        false,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      DayControlListSyBo dayControlSyBo =
          DayControlListSyBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return dayControlSyBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///使用单位-周排查、风险整改列表
  static Future getFindUserAllTaskWeekList(
      BuildContext context, taskState, beginTime, unitType) async {
    Map<String, dynamic> params = {
      'delFlag': '0',
      'userids': StorageUtil.getInstance().getUserId(),
      'taskState': taskState,
      'beginTime': beginTime,
      'deviceType.unitType': unitType
    };
    var response = await NetUtils.get(
        context,
        '${Api.FIND_USER_ALLTASK_WEEK_LIST};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        false,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      WeekControlListSyBo dayControlSyBo =
          WeekControlListSyBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return dayControlSyBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///使用单位-周排查、风险整改、已完成列表
  static Future getFindUserAllTaskMonthList(
      BuildContext context, taskState, beginTime, unitType) async {
    Map<String, dynamic> params = {
      'delFlag': '0',
      'userids': StorageUtil.getInstance().getUserId(),
      'taskState': taskState,
      'beginTime': beginTime,
      'deviceType.unitType': unitType
    };
    var response = await NetUtils.get(
        context,
        '${Api.FIND_USER_ALLTASK_MONTH_LIST};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        false,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      MonthControlListSyBo dayControlSyBo =
          MonthControlListSyBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return dayControlSyBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///使用单位-生产单位-日管控
  static Future getFindTaskDayCheck(BuildContext context, id) async {
    Map<String, dynamic> params = {
      'id': id,
    };
    var response = await NetUtils.get(
        context,
        '${Api.FIND_TASK_DAY_CHECK_LIST_TASKDAY};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      DayDetailBo dayDetailBo = DayDetailBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return dayDetailBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///使用单位-生产单位-周排查
  static Future getFindTaskWeekCheck(BuildContext context, id) async {
    Map<String, dynamic> params = {
      'id': id,
    };
    var response = await NetUtils.get(
        context,
        '${Api.FIND_TASK_DAY_CHECK_LIST_TASKWEEK};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      WeekDetailBo weekDetailBo = WeekDetailBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return weekDetailBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///使用单位-生产单位-月调度
  static Future getFindTaskMonthCheck(BuildContext context, id) async {
    Map<String, dynamic> params = {
      'id': id,
    };
    var response = await NetUtils.get(
        context,
        '${Api.FIND_TASK_DAY_CHECK_LIST_TASKMONTH};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      MonthDetailBo dayControlSyBo = MonthDetailBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return dayControlSyBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///使用单位、生产单位-日管控风险整改
  static Future getFindRiskTaskDayCheck(BuildContext context, id) async {
    Map<String, dynamic> params = {
      'id': id,
    };
    var response = await NetUtils.get(
        context,
        '${Api.FIND_TASK_DAY_CHECK_LIST_TASKDAY};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        params);

    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      DayDetailBo dayDetailBo = DayDetailBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return dayDetailBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///使用单位、生产单位-周排查 风险整改
  static Future getFindRiskTaskWeekCheck(BuildContext context, id) async {
    Map<String, dynamic> params = {
      'id': id,
    };
    var response = await NetUtils.get(
        context,
        '${Api.FIND_TASK_DAY_CHECK_LIST_TASKWEEK};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        params);

    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      WeekDetailBo weekDetailBo = WeekDetailBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return weekDetailBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///使用单位、生产单位-月调度风险整改
  static Future getFindRiskTaskMonthCheck(BuildContext context, id) async {
    Map<String, dynamic> params = {
      'id': id,
    };
    var response = await NetUtils.get(
        context,
        '${Api.FIND_TASK_DAY_CHECK_LIST_TASKMONTH};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      MonthDetailBo monthDetailBo = MonthDetailBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return monthDetailBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///使用单位-日管控 已完成
  static Future getFindCompletedTaskDayCheck(
      BuildContext context, id, type) async {
    Map<String, dynamic> params = {
      'id': id,
    };
    var response = await NetUtils.get(
        context,
        '${Api.FIND_TASK_DAY_CHECK_LIST_TASKDAY};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      DayDetailBo dayControlSyBo = DayDetailBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return dayControlSyBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///使用单位-周排查 已完成
  static Future getFindCompletedTaskWeekCheck(
      BuildContext context, id, type) async {
    Map<String, dynamic> params = {
      'id': id,
    };
    var response = await NetUtils.get(
        context,
        '${Api.FIND_TASK_DAY_CHECK_LIST_TASKWEEK};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      WeekDetailBo weekDetailBo = WeekDetailBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return weekDetailBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///使用单位-月调度已完成
  static Future getFindCompletedTaskMonthCheck(
      BuildContext context, id, type) async {
    Map<String, dynamic> params = {
      'id': id,
    };
    var response = await NetUtils.get(
        context,
        '${Api.FIND_TASK_DAY_CHECK_LIST_TASKMONTH};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      MonthDetailBo dayControlSyBo = MonthDetailBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return dayControlSyBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///使用单位-日管控、风险整改提交
  static Future getDayTaskSave(BuildContext context, taskDay) async {
    Map<String, dynamic> params = {};
    var response = await NetUtils.posts(
        context,
        '${Api.TASK_DAY_SAVE};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        taskDay,
        params,
        '提交中');
    try {
      BaseModel entity = BaseModel.fromJson(response);
      if (entity.errorCode == "-1") {
        return entity;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///使用单位-日管控、风险整改提交
  static Future getWeekTaskSave(BuildContext context, taskDay) async {
    Map<String, dynamic> params = {};
    var response = await NetUtils.posts(
        context,
        '${Api.TASK_WEEK_SAVE};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        taskDay,
        params,
        '提交中');
    try {
      BaseModel entity = BaseModel.fromJson(response);
      if (entity.errorCode == "-1") {
        return entity;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///使用单位-日管控、风险整改提交
  static Future getMonthTaskSave(BuildContext context, taskDay) async {
    Map<String, dynamic> params = {};
    var response = await NetUtils.posts(
        context,
        '${Api.TASK_MONTH_SAVE};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        taskDay,
        params,
        '提交中');
    try {
      BaseModel entity = BaseModel.fromJson(response);
      if (entity.errorCode == "-1") {
        return entity;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///版本更新
  static Future getVersionUpdate(BuildContext context) async {
    var response = await NetUtils.get(
        context,
        '${Api.VERSION_UPDATE_URL};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        false);
    log(response.toString());
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      VersionBo versionBo = VersionBo.fromJson(resultData);
      if (versionBo != null) {
        return versionBo;
      } else {
        ToastUtils.showCenter('检测版本出错');
        return;
      }
    } catch (e) {
      log(e.toString());
//      ToastUtil.showToastBottom(context, e.toString());
      return {"message": e.toString()};
    }
  }

  ///下载
  static Future downLoad(
      String url, String savePath, ProgressCallback onReceiveProgress) async {
    try {
//      dio.options.headers['token'] = Global?.profile()?.token ?? '';
      var response = await dio.download(url, savePath,
          onReceiveProgress: onReceiveProgress);
      log('请求成功====url:$url\ndata:${response.data}');
      return response.data;
    } catch (e) {
      log('请求失败====url:$url\nmessage":${e.toString()}');
      return {"result": -1, "message": e.toString()};
    }
  }

  ///多文件上传
  static Future uploadMultifile(
      BuildContext context, List<String> imagePaths) async {
    var response = await NetUtils.uploadMultifile(
        context,
        '${Api.UPLOAD_MULTIFILE};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        imagePaths,
        true);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      UploadMultifile uploadMultifile = UploadMultifile.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return uploadMultifile;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///地址
  static Future getTreeData(BuildContext context) async {
    Map<String, dynamic> params = {};
    var response = await NetUtils.gets(context, Api.TREE_DATA, true, params);
    try {
      List<CityAddressBo> addressList = [];
      List resultData = response;
      for (int i = 0; i < resultData.length; i++) {
        Map<String, dynamic> resultItem = resultData[i];
        addressList.add(CityAddressBo.fromJson(resultItem));
      }
      if (addressList != null) {
        return addressList;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///设备
  static Future getDeviceData(BuildContext context, unitType) async {
    Map<String, dynamic> params = {'unitType': unitType, 'pageSize': '-1'};
    var response = await NetUtils.gets(context, Api.DEVICE_DATA, true, params);
    try {
      Map<String, dynamic> resultData = response;
      EquipmentBo equipmentBo = EquipmentBo.fromJson(resultData);
      return equipmentBo;
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///用户 获取角色
  static Future getAppRoles(BuildContext context) async {
    Map<String, dynamic> params = {};
    var response = await NetUtils.gets(
        context,
        '${Api.GET_APP_ROLES};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      AppRoles appRoles = AppRoles.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return appRoles;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  /// 获取用户信息
  static Future getAppUser(BuildContext context, userId) async {
    Map<String, dynamic> params = {'userId': userId};
    var response = await NetUtils.gets(
        context,
        '${Api.GET_APP_USER};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      AppRoles appRoles = AppRoles.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return appRoles;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///设备
  static Future getOfficeDevice(BuildContext context) async {
    Map<String, dynamic> params = {
      'id': StorageUtil.getInstance().getOfficeId()
    };
    var response = await NetUtils.gets(
        context,
        '${Api.GET_OFFICE};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      OfficeDevice officeDevice = OfficeDevice.fromJson(resultData);
      return officeDevice;
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///单位注册提交接口
  static Future getUnitRigister(BuildContext context, user) async {
    Map<String, dynamic> params = {};
    var response = await NetUtils.posts(
        context, Api.REGISTER_APP_USER, true, user, params, '注册中');
    try {
      BaseModel entity = BaseModel.fromJson(response);
      if (entity.errorCode == "-1") {
        return entity;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///用户新建、修改提交接口
  static Future getUserSaveApp(BuildContext context, user) async {
    Map<String, dynamic> params = {};
    var response = await NetUtils.posts(
        context,
        '${Api.USER_SAVE_APP};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        user,
        params,
        '提交中');
    try {
      BaseModel entity = BaseModel.fromJson(response);
      if (entity.errorCode == "-1") {
        return entity;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///用户删除
  static Future getUserDetele(BuildContext context, user) async {
    Map<String, dynamic> params = {};
    var response = await NetUtils.posts(
        context,
        '${Api.USER_DETELE};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        user,
        params,
        '删除中');
    try {
      BaseModel entity = BaseModel.fromJson(response);
      if (entity.errorCode == "-1") {
        return entity;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///设备新建、修改提交接口
  static Future getDeviceSaveApp(BuildContext context, user) async {
    Map<String, dynamic> params = {};
    var response = await NetUtils.posts(
        context,
        '${Api.DEVICE_SAVE_APP};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        user,
        params,
        '提交中');
    try {
      BaseModel entity = BaseModel.fromJson(response);
      if (entity.errorCode == "-1") {
        return entity;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///单位设置提交
  static Future getUnitSaveApp(BuildContext context, user) async {
    Map<String, dynamic> params = {};
    var response = await NetUtils.posts(
        context,
        '${Api.UNIT_SAVE_APP};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        user,
        params,
        '提交中');
    try {
      BaseModel entity = BaseModel.fromJson(response);
      if (entity.errorCode == "-1") {
        return entity;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///设备删除
  static Future getDeviceDetele(BuildContext context, user) async {
    Map<String, dynamic> params = {};
    var response = await NetUtils.posts(
        context,
        '${Api.DEVICE_DETELE};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        user,
        params,
        '删除中');
    try {
      BaseModel entity = BaseModel.fromJson(response);
      if (entity.errorCode == "-1") {
        return entity;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///用户列表
  ///office.id: 4aba9ee297404737b361208049b9c0f2
  // pageNo: 1
  // pageSize: 10

  static Future getUserList(BuildContext context, pageNo) async {
    Map<String, dynamic> params = {
      'office.id': StorageUtil.getInstance().getOfficeId(),
      'pageNo': pageNo,
      'pageSize': -1
    };
    var response = await NetUtils.gets(
        context,
        '${Api.USER_LIST};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        false,
        params);
    try {
      Map<String, dynamic> resultData = response;
      UserList userList = UserList.fromJson(resultData);
      return userList;
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///使用单位 设备列表
  ///office.id: 4aba9ee297404737b361208049b9c0f2
  // pageNo: 1
  // pageSize: 10

  static Future getDeviceList(BuildContext context, pageNo) async {
    Map<String, dynamic> params = {
      'office.id': StorageUtil.getInstance().getOfficeId(),
      'pageNo': pageNo,
      'pageSize': -1
    };
    var response = await NetUtils.gets(
        context,
        '${Api.SY_DEVICE_LIST};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        false,
        params);
    try {
      Map<String, dynamic> resultData = response;
      SyDeviceListBo userList = SyDeviceListBo.fromJson(resultData);
      return userList;
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///获取已选择的设备列表
  static void doDeviceList(BuildContext context, pageNo, unitType,
      {Function(DeviceListBo bo)? onSuccess}) {
    Map<String, dynamic> params = {
      'officeId': StorageUtil.getInstance().getOfficeId(),
      'unitType': unitType,
      'pageNo': pageNo,
      'pageSize': -1
    };
    DoUtils.get(context,
        '${Api.GET_PRODUCE_APP_LIST};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        parameters: params,
        isLoading: true,
        loadingText: '正在加载', onSuccess: (Response response) {
      var resultObj = ResultObjBo.fromJson(
          response.data, (json) => DeviceListBo.fromJson(json));
      DeviceListBo? bo = resultObj.body;
      onSuccess!(bo!);
    }, onError: (e) {});
  }

  ///获取单位 设备人员对比
  static void doFindNatureDtoList(BuildContext context,
      {Function(RoleBo bo)? onSuccess}) {
    Map<String, dynamic> params = {
      'officeId': StorageUtil.getInstance().getOfficeId(),
    };
    DoUtils.get(context,
        '${Api.FIND_NATURE_DTO_LIST};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        parameters: params,
        isLoading: true,
        loadingText: '正在加载', onSuccess: (Response response) {
      var resultObj =
          ResultObjBo.fromJson(response.data, (json) => RoleBo.fromJson(json));
      RoleBo? bo = resultObj.body;
      onSuccess!(bo!);
    }, onError: (e) {});
  }

  ///是否隐藏注册
  static void doAppIsOpen(BuildContext context,
      {Function(AppIsOpen bo)? onSuccess}) {
    Map<String, dynamic> params = {
      'officeId': StorageUtil.getInstance().getOfficeId(),
    };
    DoUtils.get(context, Api.GET_APP_IS_OPEN,
        parameters: params,
        isLoading: true,
        loadingText: '正在加载', onSuccess: (Response response) {
      var resultObj = ResultObjBo.fromJson(
          response.data, (json) => AppIsOpen.fromJson(json));
      AppIsOpen? bo = resultObj.body;
      onSuccess!(bo!);
    }, onError: (e) {});
  }

  /// 公司账户-首页-设备对比表格 获取主要负责人
  static void doFindChargeList(BuildContext context,
      {Function(FindChargeListBo bo)? onSuccess}) {
    Map<String, dynamic> params = {
      'officeId': StorageUtil.getInstance().getOfficeId(),
    };
    DoUtils.get(context,
        '${Api.FIND_CHARGE_LIST};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        parameters: params,
        isLoading: false,
        loadingText: '正在加载', onSuccess: (Response response) {
      var resultObj = ResultObjBo.fromJson(
          response.data, (json) => FindChargeListBo.fromJson(json));
      FindChargeListBo? bo = resultObj.body;
      onSuccess!(bo!);
    }, onError: (e) {});
  }

  /// 公司账户-首页-设备对比表格 获取使用单位设备数量
  static void doFindCount(BuildContext context,
      {Function(FindCountBo bo)? onSuccess}) {
    Map<String, dynamic> params = {
      'officeId': StorageUtil.getInstance().getOfficeId(),
    };
    DoUtils.get(context,
        '${Api.FIND_COUNT};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        parameters: params,
        isLoading: false,
        loadingText: '正在加载', onSuccess: (Response response) {
      var resultObj = ResultObjBo.fromJson(
          response.data, (json) => FindCountBo.fromJson(json));
      FindCountBo? bo = resultObj.body;
      onSuccess!(bo!);
    }, onError: (e) {});
  }

  ///考核
  static Future getExamineQuestions(BuildContext context, inspectorsId,
      examDate, typeId, questionNum, dxNum, pdNum, personId) async {
    Map<String, dynamic> params = {
      'user.id': StorageUtil.getInstance().getUserId(),
      'inspectors.id': inspectorsId,
      'examDate': examDate,
      'type.id': typeId,
      'questionNum': questionNum,
      'dxNum': dxNum,
      'pdNum': pdNum,
      'personId': personId
    };
    var response = await NetUtils.get(
        context,
        '${Api.EXAMINE_QUESTIONS};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        params,
        '正在获取题库...');
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;

      ExamineQuestionsBo examineQuestionsBo =
          ExamineQuestionsBo.fromJson(resultData);

      if (entity.errorCode == "-1") {
        return examineQuestionsBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///考核提交
  static Future getExamSubmit(BuildContext context, data) async {
    Map<String, dynamic> params = {};
    var response = await NetUtils.posts(
        context,
        '${Api.EXAMINE_QUESTIONS_SUBMIT};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        data,
        params,
        '交卷中');
    try {
      BaseModel entity = BaseModel.fromJson(response);
      if (entity.success!) {
        Map<String, dynamic> resultData = entity.body;
        ExamResultBo examResultBo = ExamResultBo.fromJson(resultData);
        if (entity.errorCode == "-1") {
          return examResultBo;
        } else {
          ToastUtils.showCenter(entity.msg!);
          return;
        }
      } else {
        showDialog(
            context: context,
            barrierDismissible: false,
            builder: (context) {
              return AlertDialog(
                title: const Text("温馨提示"),
                content: Text(entity.msg!),
                actionsPadding: const EdgeInsets.only(
                    left: 0, top: 0, bottom: 10, right: 20),
                contentPadding: const EdgeInsets.only(
                    left: 20, top: 0, bottom: 10, right: 20),
                titlePadding: const EdgeInsets.only(
                    left: 20, top: 20, bottom: 10, right: 20),
                actions: [
                  TextButton(
                      child: const Text("确定"),
                      onPressed: () {
                        //发出通知
                        EventBusUtils.getInstance()?.fire("1");
                        Get.back();
                        Get.back();
                      })
                ],
              );
            });
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///测试练习提交
  static Future getTestSubmit(BuildContext context, data) async {
    Map<String, dynamic> params = {};
    var response = await NetUtils.posts(
        context,
        '${Api.EXAMINE_TEST_SUBMIT};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        data,
        params,
        '交卷中');
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      ExamResultBo examResultBo = ExamResultBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return examResultBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///获取练习题库
  static Future getTestQuestions(BuildContext context, typeId, positionType,
      questionNum, dxNum, pdNum) async {
    Map<String, dynamic> params = {
      'user.id': StorageUtil.getInstance().getUserId(),
      'type.id': typeId,
      'positionType': positionType,
      'questionNum': questionNum,
      'dxNum': dxNum,
      'pdNum': pdNum
    };
    var response = await NetUtils.get(
        context,
        '${Api.TEST_QUESTIONS};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        params,
        '正在获取题库...');
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;

      TestQuestionsBo examineQuestionsBo = TestQuestionsBo.fromJson(resultData);

      if (entity.errorCode == "-1") {
        return examineQuestionsBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///单位列表
  static Future getUnitList(BuildContext context, parentId) async {
    Map<String, dynamic> params = {'id': parentId};
    var response = await NetUtils.get(
        context,
        '${Api.GET_UNIT_LIST};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      ExamUnitList examUnitList = ExamUnitList.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return examUnitList;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///设备类型
  static Future getEquipmentList(BuildContext context, officeId) async {
    Map<String, dynamic> params = {'officeId': officeId};
    var response = await NetUtils.get(
        context,
        '${Api.GET_EQUIPMENT_LIST};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      EquipmentListBo equipmentListBo = EquipmentListBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return equipmentListBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///获取单位考试人员
  static Future getUnitPerson(
      BuildContext context, officeId, typeId, roleId) async {
    Map<String, dynamic> params = {
      'officeId': officeId,
      'typeId': typeId,
      'roleId': roleId
    };
    var response = await NetUtils.get(
        context,
        '${Api.GET_UNIT_PERSON};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      UnitPersonListBo unitPersonListBo = UnitPersonListBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return unitPersonListBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///获取默认题数
  static Future getFindQuestionNum(BuildContext context) async {
    Map<String, dynamic> params = {};
    var response = await NetUtils.get(
        context,
        '${Api.FIND_QUESTION_NUM};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      FindQuestionNum findQuestionNum = FindQuestionNum.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return findQuestionNum;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///考核设置提交（监察人）
  static Future getExamSettingSubmit(BuildContext context, data) async {
    Map<String, dynamic> params = {};
    var response = await NetUtils.posts(
        context,
        '${Api.GET_OVERSEER_SAVE};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        data,
        params,
        '提交中...');
    try {
      BaseModel entity = BaseModel.fromJson(response);
      // Map<String, dynamic> resultData = entity.body;
      // ExamResultBo examResultBo = ExamResultBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return entity;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///设置考核信息，权限
  static Future getExaminePerson(BuildContext context) async {
    Map<String, dynamic> params = {};
    var response = await NetUtils.get(
        context,
        '${Api.CHECK_HAVE_EXAM};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        false,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      ExaminePersonBo examinePersonBo = ExaminePersonBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return examinePersonBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///获取考核列表
  static Future getOverseerList(
      BuildContext context, taskState, beginTime, unitType) async {
    Map<String, dynamic> params = {
      'delFlag': '0',
      'userids': StorageUtil.getInstance().getUserId()
    };
    var response = await NetUtils.get(
        context,
        '${Api.GET_OVERSEER_LIST};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        false,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      DayControlListSyBo dayControlSyBo =
          DayControlListSyBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return dayControlSyBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///考核列表删除
  static Future getOverseerDelete(
      BuildContext context, taskState, beginTime, unitType) async {
    Map<String, dynamic> params = {'ids': '0'};
    var response = await NetUtils.get(
        context,
        '${Api.GET_OVERSEER_DELETE};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        false,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      DayControlListSyBo dayControlSyBo =
          DayControlListSyBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return dayControlSyBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///根据设备类型获取总题数
  static Future getFindEqQuestionNum(BuildContext context, String type) async {
    Map<String, dynamic> params = {"type": type};
    var response = await NetUtils.get(
        context,
        '${Api.FINT_QUESTION_TYPE};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        true,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      EqQuestionBo findQuestionNum = EqQuestionBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return findQuestionNum;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///考核 是否显示答案
  static Future getShowAnswer(BuildContext context) async {
    Map<String, dynamic> params = {};
    var response = await NetUtils.get(
        context,
        '${Api.SHOW_ANSWER};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        false,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      ShowAnswerBo mShowAnswerBo = ShowAnswerBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return mShowAnswerBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///监察记录 详情基本信息
  static Future getPapers2(
      BuildContext context, String inspectorsId, String setup) async {
    Map<String, dynamic> params = {
      "inspectorsId": inspectorsId,
      "setup": setup
    };
    var response = await NetUtils.get(
        context,
        '${Api.GET_PAPERS_DETAIL};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        false,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      OverseerHistoryInformationBo mOverseerHistoryListBo =
          OverseerHistoryInformationBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return mOverseerHistoryListBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///监察记录 列表
  static Future getPapers(BuildContext context, String inspectorsId, int pageNo,
      int pageSize) async {
    Map<String, dynamic> params = {
      "inspectorsId": inspectorsId,
      "pageNo": pageNo,
      "pageSize": pageSize
    };
    var response = await NetUtils.get(
        context,
        '${Api.EXAM_SETUP_GET_PAPERS};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        false,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      OverseerHistoryListBo mOverseerHistoryListBo =
          OverseerHistoryListBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return mOverseerHistoryListBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///监察记录 详情
  static Future getExamPersonData(BuildContext context, String setup) async {
    Map<String, dynamic> params = {"setup": setup};
    var response = await NetUtils.get(
        context,
        '${Api.EXAM_PERSON_DATA};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        false,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      OverseerHistoryDetailsBo mOverseerHistoryDetailsBo =
          OverseerHistoryDetailsBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return mOverseerHistoryDetailsBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///监察记录 删除
  static Future getExamSetupDelete(BuildContext context, String id) async {
    Map<String, dynamic> params = {"id": id};
    var response = await NetUtils.get(
        context,
        '${Api.EXAM_SETUP_DELETE};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        false,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      ShowAnswerBo mShowAnswerBo = ShowAnswerBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return mShowAnswerBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

  ///首页广告 banner
  static Future getBannerList(BuildContext context) async {
    Map<String, dynamic> params = {};
    var response = await NetUtils.get(
        context,
        '${Api.BANNER};JSESSIONID=${StorageUtil.getInstance().getJsessionId()}',
        false,
        params);
    try {
      BaseModel entity = BaseModel.fromJson(response);
      Map<String, dynamic> resultData = entity.body;
      BannerListBo mBannerListBo = BannerListBo.fromJson(resultData);
      if (entity.errorCode == "-1") {
        return mBannerListBo;
      } else {
        ToastUtils.showCenter(entity.msg!);
        return;
      }
    } catch (e) {
      log(e.toString());
      return {"message": e.toString()};
    }
  }

//  HttpUtils.getList(context, _page, 20).then((value) {
//  ListBo listBo = value;
//  print(listBo);
//  if (listBo.errorCode == '-1') {
//  var inspectControlList = listBo.body?.inspectControlList?.rows;
//  print("xxxx1---${inspectControlList?.length}");
//  setState(() {
//  _list.addAll(inspectControlList!);
//  _page++;
//  print("xxxx2---${inspectControlList.length}");
//  });
//  } else {}

//
//  /* 修改密码*/
//  static Future<String> changePwd(
//      String oldPwd, String newPwd, String confirmPassword) async {
//    Map<String, dynamic> params = {};
//    params['pwd'] = base64Encode(utf8.encode(oldPwd)).toString();
//    params['newPwd'] = base64Encode(utf8.encode(newPwd)).toString();
//    params['confirmPassword'] =
//        base64Encode(utf8.encode(confirmPassword)).toString();
//    var response =
//        await NetUtils.post(Global.testHostUrl() + Api.CHANGE_PWD, params);
//    try {
//      if (response['result'] == 1) {
//        Global.savePassWord(newPwd);
//        return "";
//      } else {
//        return response['message'];
//      }
//    } catch (e) {
//      return e.toString();
//    }
//  }
//
//  static Future<VersionInfo> fetchVersionUpdate(String versionCode) async {
//    Map<String, dynamic> params = {"type": "Android"};
//    params["curVersionCode"] = versionCode;
//    var response = await NetUtils.post(Api.VERSION_UPDATE, params);
//    try {
//      if (response['result'].toString() == '1') {
//        Map<String, dynamic> resultData = response['data'];
//        VersionInfo versionInfo = VersionInfo.fromJson(resultData);
//        return versionInfo;
//      } else {
//        return VersionInfo();
//      }
//    } catch (e) {
//      print(e.toString());
//      return VersionInfo()..message = e.toString();
//    }
//  }
//
//  static Future<Tuple2<String, String>> fetchIOSVersionUpdate(
//      String appleId) async {
//    Map<String, dynamic> params = {};
//    String url = 'https://itunes.apple.com/cn/lookup?id=$appleId';
//    var response = await NetUtils.post(url, params);
//    try {
//      var responseMap = json.decode(response);
//      if (responseMap['resultCount'] == 1) {
//        //返回的是集合
//        List resultData = responseMap['results'];
//        String version;
//        String releaseNotes;
//        if (resultData != null) {
//          version = resultData[0]['version'];
//          releaseNotes = resultData[0]['releaseNotes'];
//        }
//        return Tuple2(version, releaseNotes);
//      } else {
//        return Tuple2('', '');
//      }
//    } catch (e) {
//      return Tuple2('', '');
//    }
//  }
//
//  static Future<Tuple3<bool, List<AppMenuListModel>, int>>
//      fetchMenuList() async {
//    Map<String, dynamic> params = {};
//    var response =
//        await NetUtils.post(Global.testHostUrl() + Api.APP_MENU_LIST, params);
//    List<AppMenuListModel> menuList = [];
//    int crossAxisCount;
//    try {
//      if (response['result'] == 1) {
//        List resultData = response['dataList'];
//        crossAxisCount = response['crossAxisCount'];
//        for (int i = 0; i < resultData.length; i++) {
//          Map<String, dynamic> resultItem = resultData[i];
//          menuList.add(AppMenuListModel.fromJson(resultItem));
//        }
//        return Tuple3(true, menuList, crossAxisCount);
//      } else {
//        return Tuple3(false, menuList, crossAxisCount);
//      }
//    } catch (e) {
//      print(e);
//      return Tuple3(false, menuList, crossAxisCount);
//    }
//  }
//
//  static Future<Tuple2<bool, List<CarouselModel>>>
//      fetchHomeImageCarousel() async {
//    Map<String, dynamic> params = {};
//    var response = await NetUtils.post(
//        Global.testHostUrl() + Api.HOME_IMAGE_CAROUSEL, params);
//    List<CarouselModel> list = [];
//    try {
//      if (response['result'] == 1) {
//        List resultData = response['dataList'];
//        for (int i = 0; i < resultData.length; i++) {
//          Map<String, dynamic> resultItem = resultData[i];
//          list.add(CarouselModel.fromJson(resultItem));
//        }
//        return Tuple2(true, list);
//      } else {
//        return Tuple2(false, list);
//      }
//    } catch (e) {
//      return Tuple2(false, list);
//    }
//  }
//
//  static Future<Tuple2<bool, List<CarouselModel>>> fetchQrCodeList() async {
//    Map<String, dynamic> params = {};
//    var response =
//        await NetUtils.post(Global.testHostUrl() + Api.QR_CODE_LIST, params);
//    List<CarouselModel> list = [];
//    try {
//      if (response['result'] == 1) {
//        List resultData = response['dataList'];
//        for (int i = 0; i < resultData.length; i++) {
//          Map<String, dynamic> resultItem = resultData[i];
//          list.add(CarouselModel.fromJson(resultItem));
//        }
//        return Tuple2(true, list);
//      } else {
//        return Tuple2(false, list);
//      }
//    } catch (e) {
//      return Tuple2(false, list);
//    }
//  }
//
//  static Future<WeatherModel> fetchWeatherData() async {
//    Map<String, dynamic> params = {};
//    var response =
//        await NetUtils.get(Global.testHostUrl() + Api.WEATHER, params);
//    try {
//      if (response['result'] == 1 &&
//          !StringUtils.strIsEmpty(response['data'])) {
//        WeatherModel weatherModel =
//            WeatherModel.fromJson(jsonDecode(response['data']));
//        if (weatherModel != null) {
//          Global.saveWeather(weatherModel);
//          return weatherModel;
//        } else {
//          return null;
//        }
//      } else {
//        return null;
//      }
//    } catch (e) {
//      return null;
//    }
//  }
//
//  static Future<Tuple2<String, List<ArticleModel>>>
//      fetchHomeUpdateMessageList() async {
//    Map<String, dynamic> params = {};
//    var response = await NetUtils.post(
//        Global.testHostUrl() + Api.HOME_LATEST_UPDATE, params);
//    List<ArticleModel> list = [];
//    try {
//      if (response['result'] == 1) {
//        List resultData = response['dataList'];
//        for (int i = 0; i < resultData.length; i++) {
//          Map<String, dynamic> resultItem = resultData[i];
//          list.add(ArticleModel.fromJson(resultItem));
//        }
//        return Tuple2(response['title'], list);
//      } else {
//        return Tuple2(null, list);
//      }
//    } catch (e) {
//      return Tuple2(null, list);
//    }
//  }
//
//  static Future<Tuple2<bool, List<ClassifyModel>>> fetchCategoryList() async {
//    Map<String, dynamic> params = {};
//    var response = await NetUtils.post(
//        Global.testHostUrl() + Api.FIND_CATEGORY_LIST, params);
//    List<ClassifyModel> list = [];
//    try {
//      if (response['result'] == 1) {
//        List resultData = response['data'];
//        for (int i = 0; i < resultData.length; i++) {
//          Map<String, dynamic> resultItem = resultData[i];
//          list.add(ClassifyModel.fromJson(resultItem));
//        }
//        return Tuple2(true, list);
//      } else {
//        return Tuple2(false, list);
//      }
//    } catch (e) {
//      print(e);
//      return Tuple2(false, list);
//    }
//  }
//
//  static Future<Tuple2<bool, List<ClassifyModel>>> fetchCategoryListById(
//      int categoryId) async {
//    Map<String, dynamic> params = {'categoryId': categoryId};
//    var response = await NetUtils.post(
//        Global.testHostUrl() + Api.FIND_CATEGORY_LIST_BY_ID, params);
//    List<ClassifyModel> list = [];
//    try {
//      if (response['result'] == 1) {
//        List resultData = response['data'];
//        for (int i = 0; i < resultData.length; i++) {
//          Map<String, dynamic> resultItem = resultData[i];
//          list.add(ClassifyModel.fromJson(resultItem));
//        }
//        return Tuple2(true, list);
//      } else {
//        return Tuple2(false, list);
//      }
//    } catch (e) {
//      print(e);
//      return Tuple2(false, list);
//    }
//  }
//
//  static Future<Tuple2<bool, List<ClassifyModel>>>
//      fetchCategoryChildrenListById(int categoryId, {String keyWord}) async {
//    Map<String, dynamic> params = {
//      'categoryId': categoryId,
//      'keyWord': keyWord
//    };
//    var response = await NetUtils.post(
//        Global.testHostUrl() + Api.FIND_CATEGORY_CHILDREN_LIST_BY_ID, params);
//    List<ClassifyModel> list = [];
//    try {
//      if (response['result'] == 1) {
//        List resultData = response['data'];
//        for (int i = 0; i < resultData.length; i++) {
//          Map<String, dynamic> resultItem = resultData[i];
//          list.add(ClassifyModel.fromJson(resultItem));
//        }
//        return Tuple2(true, list);
//      } else {
//        return Tuple2(false, list);
//      }
//    } catch (e) {
//      print(e);
//      return Tuple2(false, list);
//    }
//  }
//
//  static Future<Tuple2<bool, List<ArticleModel>>> fetchArticleList(
//      int page, int categoryId,
//      {String keyWord, bool publicFlag}) async {
//    Map<String, dynamic> params = {
//      'page': page,
//      'categoryId': categoryId,
//      'keyWord': keyWord,
//      'publicFlag': publicFlag
//    };
//    var response =
//        await NetUtils.post(Global.testHostUrl() + Api.ARTICLE_LIST, params);
//    List<ArticleModel> list = [];
//    try {
//      if (response['result'] == 1) {
//        List resultData = response['data']['results'];
//        for (int i = 0; i < resultData.length; i++) {
//          Map<String, dynamic> resultItem = resultData[i];
//          list.add(ArticleModel.fromJson(resultItem));
//        }
//        return Tuple2(response['data']['lastPage'] ?? true, list);
//      } else {
//        return Tuple2(true, list);
//      }
//    } catch (e) {
//      print(e);
//      return Tuple2(true, list);
//    }
//  }
//
//  static Future<Tuple2<bool, List<ArticleModel>>> fetchArticleCollectList(
//      int page,
//      {String keyWord,
//      bool publicFlag}) async {
//    Map<String, dynamic> params = {
//      'page': page,
//      'keyWord': keyWord,
//      'publicFlag': publicFlag
//    };
//    var response = await NetUtils.post(
//        Global.testHostUrl() + Api.ARTICLE_GET_COLLECT_LIST, params);
//    List<ArticleModel> list = [];
//    try {
//      if (response['result'] == 1) {
//        List resultData = response['data']['results'];
//        for (int i = 0; i < resultData.length; i++) {
//          Map<String, dynamic> resultItem = resultData[i];
//          list.add(ArticleModel.fromJson(resultItem));
//        }
//        return Tuple2(response['data']['lastPage'] ?? true, list);
//      } else {
//        return Tuple2(true, list);
//      }
//    } catch (e) {
//      print(e);
//      return Tuple2(true, list);
//    }
//  }
//
//  static Future<Tuple2<bool, List<WebsiteModel>>> fetchWebsiteList() async {
//    Map<String, dynamic> params = {};
//    var response =
//        await NetUtils.post(Global.testHostUrl() + Api.WEBSITE_LIST, params);
//    List<WebsiteModel> list = [];
//    try {
//      if (response['result'] == 1) {
//        List resultData = response['data'];
//        for (int i = 0; i < resultData.length; i++) {
//          Map<String, dynamic> resultItem = resultData[i];
//          list.add(WebsiteModel.fromJson(resultItem));
//        }
//        return Tuple2(true, list);
//      } else {
//        return Tuple2(false, list);
//      }
//    } catch (e) {
//      print(e);
//      return Tuple2(false, list);
//    }
//  }
//
//  static Future<Tuple2<bool, List<DiscussModel>>> fetchDiscussList(int page,
//      {String keyWord}) async {
//    Map<String, dynamic> params = {
//      'page': page,
//      'keyWord': keyWord,
//    };
//    var response =
//        await NetUtils.post(Global.testHostUrl() + Api.DISCUSS_LIST, params);
//    List<DiscussModel> list = [];
//    try {
//      if (response['result'] == 1) {
//        List resultData = response['data']['results'];
//        for (int i = 0; i < resultData.length; i++) {
//          Map<String, dynamic> resultItem = resultData[i];
//          list.add(DiscussModel.fromJson(resultItem));
//        }
//        return Tuple2(response['data']['lastPage'] ?? true, list);
//      } else {
//        return Tuple2(true, list);
//      }
//    } catch (e) {
//      print(e);
//      return Tuple2(true, list);
//    }
//  }
//
//  static Future<Tuple4<bool, List<KeyValueModel>, List<IntegralModel>, int>>
//      fetchIntegralList(int page) async {
//    Map<String, dynamic> params = {'page': page, 'pageSize': 15};
//    var response =
//        await NetUtils.post(Global.testHostUrl() + Api.INTEGRAL_LIST, params);
//    List<KeyValueModel> listInfo = [];
//    List<IntegralModel> list = [];
//    try {
//      if (response['result'] == 1) {
//        List resultData = response['data']['results'];
//        if (resultData != null) {
//          for (int i = 0; i < resultData.length; i++) {
//            Map<String, dynamic> resultItem = resultData[i];
//            list.add(IntegralModel.fromJson(resultItem));
//          }
//        }
//        List dataList = response['dataList'];
//        if (dataList != null) {
//          for (int i = 0; i < dataList.length; i++) {
//            Map<String, dynamic> resultItem = dataList[i];
//            listInfo.add(KeyValueModel.fromJson(resultItem));
//          }
//        }
//        return Tuple4(response['data']['lastPage'] ?? true, listInfo, list,
//            response['data']['recordCount'] ?? 0);
//      } else {
//        return Tuple4(true, listInfo, list, 0);
//      }
//    } catch (e) {
//      print(e);
//      return Tuple4(true, listInfo, list, 0);
//    }
//  }
//
//  static Future<Tuple2<bool, List<DiscussMsgModel>>> fetchDiscussPublishMsgList(
//      int page, int id) async {
//    Map<String, dynamic> params = {
//      'page': page,
//      'categoryId': id,
//    };
//    var response = await NetUtils.post(
//        Global.testHostUrl() + Api.DISCUSS_PUBLISH_MSG_LIST, params);
//    List<DiscussMsgModel> list = [];
//    try {
//      if (response['result'] == 1) {
//        List resultData = response['data']['results'];
//        for (int i = 0; i < resultData.length; i++) {
//          Map<String, dynamic> resultItem = resultData[i];
//          list.add(DiscussMsgModel.fromJson(resultItem));
//        }
//        return Tuple2(response['data']['lastPage'] ?? true, list);
//      } else {
//        return Tuple2(true, list);
//      }
//    } catch (e) {
//      print(e);
//      return Tuple2(true, list);
//    }
//  }
//
//  //请求任意接口
//  static Future<Tuple2<bool, String>> anyRequest(
//      String url, Map<String, dynamic> paramMap,
//      {bool needJson}) async {
//    var response = await NetUtils.post(Global.testHostUrl() + url, paramMap);
//    try {
//      if (response['result'].toString() == '1') {
//        return Tuple2(true, needJson == true ? json.encode(response) : '');
//      } else {
//        return Tuple2(false, response['message']);
//      }
//    } catch (e) {
//      return Tuple2(false, e.toString());
//    }
//  }
}
