// ignore_for_file: constant_identifier_names

import 'package:get/get.dart';
import 'package:special_equipment_flutter/ui/examine/exam/exam_history_page.dart';
import 'package:special_equipment_flutter/ui/examine/exam/exam_page.dart';
import 'package:special_equipment_flutter/ui/examine/exam/exam_result_page.dart';
import 'package:special_equipment_flutter/ui/examine/test/test_page.dart';
import 'package:special_equipment_flutter/ui/examine/test/test_result_page.dart';
import 'package:special_equipment_flutter/ui/examine/test/test_setting_page.dart';
import 'package:special_equipment_flutter/ui/file/file_list_page.dart';
import 'package:special_equipment_flutter/ui/login/login_page.dart';
import 'package:special_equipment_flutter/ui/main/tab_home_page.dart';
import 'package:special_equipment_flutter/ui/main/unit/equipment_personnel_page.dart';
import 'package:special_equipment_flutter/ui/overseer/equipment_list_page1.dart';
import 'package:special_equipment_flutter/ui/overseer/overseer_history_details_page.dart';
import 'package:special_equipment_flutter/ui/overseer/overseer_history_list_page.dart';
import 'package:special_equipment_flutter/ui/overseer/overseer_settings_pages.dart';
import 'package:special_equipment_flutter/ui/overseer/unit_list_page.dart';
import 'package:special_equipment_flutter/ui/register/address_page.dart';
import 'package:special_equipment_flutter/ui/register/register_page1.dart';
import 'package:special_equipment_flutter/ui/register/register_page2.dart';
import 'package:special_equipment_flutter/ui/sy/details/day/day_completed_detail_sy_page.dart';
import 'package:special_equipment_flutter/ui/sy/details/day/day_inspect_submit_sy_page.dart';
import 'package:special_equipment_flutter/ui/sy/details/day/day_risk_submit_sy_page.dart';
import 'package:special_equipment_flutter/ui/sy/details/month/month_completed_detail_sy_page.dart';
import 'package:special_equipment_flutter/ui/sy/details/month/month_inspect_submit_sy_page.dart';
import 'package:special_equipment_flutter/ui/sy/details/month/month_risk_submit_sy_page.dart';
import 'package:special_equipment_flutter/ui/sy/details/week/week_completed_detail_sy_page.dart';
import 'package:special_equipment_flutter/ui/sy/details/week/week_inspect_submit_sy_page.dart';
import 'package:special_equipment_flutter/ui/sy/details/week/week_risk_submit_sy_page.dart';
import 'package:special_equipment_flutter/ui/sy/sy_tab_page.dart';
import 'package:special_equipment_flutter/ui/unit/equipment/equipment_settings_page.dart';
import 'package:special_equipment_flutter/ui/unit/equipment/equipment_tab_page.dart';
import 'package:special_equipment_flutter/ui/unit/unit/unit_settings_page.dart';
import 'package:special_equipment_flutter/ui/unit/user/user_list_page.dart';
import 'package:special_equipment_flutter/ui/unit/user/user_settings_page.dart';

class RouteString {
  ///登录
  static const String LOGIN = "/login";

  ///注册
  static const String REGISTER1 = "/register1";
  static const String REGISTER2 = "/register2";

  ///注册：所属区域
  static const String ADDRESS = "/address";

  ///用户列表
  static const String UER_LIST = "/UerListPage";

  ///用户新建、修改
  static const String USER_SETTINGS = "/UserSettingsPage";

  ///设备设置Tab
  static const String EQUIPMENT_TAB = "/EquipmentTabPage";

  ///设备设置
  static const String EQUIPMENT_SETTINGS = "/EquipmentSettingsPage";

  ///单位设置
  static const String UNIT_SETTINGS = "/UnitSettingsPage";

  ///公司-首页-设备人员对比表格
  static const String EQUIPMENT_PERSONNEL = "/EquipmentPersonnelPage";

  ///首页
  static const String HOME = "/home";

  ///使用单位：日管控、周排查、月调度Tab列表
  static const String TAB_SY = "/syTab";

  ///使用单位\生产单位：日管控 检查提交
  static const String DAY_INSPECT_SUBMIT_SY = "/DayInspectSubmitSyPage";

  ///使用单位\生产单位：周排查 检查提交
  static const String WEEK_INSPECT_SUBMIT_SY = "/WeekInspectSubmitSyPage";

  ///使用单位\生产单位：月调度 检查提交
  static const String MONTH_INSPECT_SUBMIT_SY = "/MonthInspectSubmitSyPage";

  ///使用单位：日管控 风险整改提交
  static const String DAY_RISK_SUBMIT_SY = "/DayRiskSubmitSyPage";

  ///使用单位：周排查 风险整改提交
  static const String WEEK_RISK_SUBMIT_SY = "/WeekRiskSubmitSyPage";

  ///使用单位：月调度 风险整改提交
  static const String MONTH_RISK_SUBMIT_SY = "/MonthRiskSubmitSyPage";

  ///使用单位：日管控 已完成详情
  static const String DAY_COMPLETED_DETAIL_SY = "/DayCompletedDetailSyPage";

  ///使用单位：周排查 已完成详情
  static const String WEEK_COMPLETED_DETAIL_SY = "/WeekCompletedDetailSyPage";

  ///使用单位：月调度 已完成详情
  static const String MONTH_COMPLETED_DETAIL_SY = "/MonthCompletedDetailSyPage";

  ///生产单位：日管控、周排查、月调度Tab列表
  static const String TAB_SC = "/scTabPage";

  ///生产单位：日管控、周排查、月调度 检查提交
  static const String INSPECT_SUBMIT_SC = "/InspectSubmitSc";

  ///生产单位：日管控、周排查、月调度 风险整改提交
  static const String RISK_SUBMIT_SC = "/RiskSubmitSc";

  ///生产单位：日管控、周排查、月调度 已完成详情
  static const String COMPLETED_DETAIL_SC = "/CompletedDetailSc";

  ///考核做题
  static const String EXAM_PAGE = "/ExamPage";

  ///考核结果
  static const String EXAM_RESULT_PAGE = "/ExamResultPage";

  ///考核历史
  static const String EXAM_HISTORY_PAGE = "/ExamHistoryPage";

  ///测试练习
  static const String TEST_PAGE = "/TestPage";

  ///监察人员设置
  static const String OVERSEER_SETTINGS_PAGE = "/OverseerSettingsPage";

  ///监察人-选择单位
  static const String UNIT_LIST_PAGE = "/UnitListPage";

  ///监察人-选择设备
  static const String EQUIPMENT_LIST_PAGE = "/EquipmentListPage";

  ///监察人-考核列表
  static const String OVERSEER_HISTORY_LIST_PAGE = "/OverseerHistoryListPage";

  ///测试练习结果页面
  static const String TEST_RESULT_PAGE = "/TestResultPage";

  ///测试练习设置
  static const String TEST_SETTING_PAGE = "/TestSettingPage";

  ///监察记录
  static const String OVERSEER_HISTROY_DETAILS_PAGE =
      "/OverseerHistroyDetailsPage";

  ///文件预览
  static const String FILE_LIST_PAGE = "/FileListPage";

  static final routes = [
    ///登录
    GetPage(name: LOGIN, page: () => const LoginPage()),

    ///注册
    GetPage(name: REGISTER1, page: () => const RegisterPage1()),
    GetPage(name: REGISTER2, page: () => RegisterPage2()),
    GetPage(name: ADDRESS, page: () => const AddressPage()),

    ///用户列表
    GetPage(name: UER_LIST, page: () => const UserListPage()),

    ///用户新建、修改
    GetPage(name: USER_SETTINGS, page: () => UserSettingsPage()),

    ///设备设置Tab
    GetPage(name: EQUIPMENT_TAB, page: () => EquipmentTabPage()),

    ///设备设置
    GetPage(name: EQUIPMENT_SETTINGS, page: () => EquipmentSettingsPage()),

    ///单位设置
    GetPage(name: UNIT_SETTINGS, page: () => const UnitSettingsPage()),

    ///公司-首页-设备人员对比表格
    GetPage(name: EQUIPMENT_PERSONNEL, page: () => EquipmentPersonnelPage()),

    ///首页
    GetPage(name: HOME, page: () => const HomePage()),

    ///使用单位：日管控、周排查、月调度Tab列表
    GetPage(name: TAB_SY, page: () => SyTabPage()),

    ///使用单位：日管控 检查提交
    GetPage(name: DAY_INSPECT_SUBMIT_SY, page: () => DayInspectSubmitSyPage()),

    ///使用单位：周排查 检查提交
    GetPage(
        name: WEEK_INSPECT_SUBMIT_SY, page: () => WeekInspectSubmitSyPage()),

    ///使用单位：月调度 检查提交
    GetPage(
        name: MONTH_INSPECT_SUBMIT_SY, page: () => MonthInspectSubmitSyPage()),

    ///使用单位：日管控 风险整改提交
    GetPage(name: DAY_RISK_SUBMIT_SY, page: () => DayRiskSubmitSyPage()),

    ///使用单位：周排查 风险整改提交
    GetPage(name: WEEK_RISK_SUBMIT_SY, page: () => WeekRiskSubmitSyPage()),

    ///使用单位：月调度 风险整改提交
    GetPage(name: MONTH_RISK_SUBMIT_SY, page: () => MonthRiskSubmitSyPage()),

    ///使用单位：日管控 已完成详情
    GetPage(
        name: DAY_COMPLETED_DETAIL_SY, page: () => DayCompletedDetailSyPage()),

    ///使用单位：周排查 已完成详情
    GetPage(
        name: WEEK_COMPLETED_DETAIL_SY,
        page: () => WeekCompletedDetailSyPage()),

    ///使用单位：月调度 已完成详情
    GetPage(
        name: MONTH_COMPLETED_DETAIL_SY,
        page: () => MonthCompletedDetailSyPage()),

    ///考核做题
    GetPage(name: EXAM_PAGE, page: () => ExamPage()),

    ///考核历史
    GetPage(name: EXAM_HISTORY_PAGE, page: () => ExamHistoryPage()),

    ///测试练习
    GetPage(name: TEST_PAGE, page: () => TestPage()),

    ///考核结果
    GetPage(name: EXAM_RESULT_PAGE, page: () => ExamResultPage()),

    ///监察人设置考核
    GetPage(name: OVERSEER_SETTINGS_PAGE, page: () => OverseerSettingsPages()),

    ///监察人选择单位
    GetPage(name: UNIT_LIST_PAGE, page: () => UnitListPage()),

    ///监察人选择设备
    GetPage(name: EQUIPMENT_LIST_PAGE, page: () => EquipmentListPage()),

    ///考核列表
    GetPage(
        name: OVERSEER_HISTORY_LIST_PAGE,
        page: () => OverseerHistoryListPage()),

    ///测试练习结果
    GetPage(name: TEST_RESULT_PAGE, page: () => TestResultPage()),

    ///测试练习设置
    GetPage(name: TEST_SETTING_PAGE, page: () => TestSettingPage()),

    ///监察记录
    GetPage(
        name: OVERSEER_HISTROY_DETAILS_PAGE,
        page: () => OverseerHistroyDetailsPage()),

    ///文件预览
    GetPage(name: FILE_LIST_PAGE, page: () => FileListPage()),

    // GetPage(
    //     name: "/shop",
    //     page: () => const ShopPage(),
    //     middlewares: [ShopMiddleWare()]),
    // GetPage(name: "/login", page: () => const LoginPage()),
    // GetPage(
    //     name: "/registerFirst",
    //     page: () => const RegisterFirstPage(),
    //     transition: Transition.fade), // 单独指定某个路由页面切换效果
    // GetPage(name: "/registerSecond", page: () => const RegisterSecondPage()),
    // GetPage(name: "/registerThird", page: () => const RegisterThirdPage()),
  ];
}
