import { fileURLToPath, URL } from "node:url";

import { defineConfig } from "vite";
import vue from "@vitejs/plugin-vue";
import path from "path";
import vueDevTools from "vite-plugin-vue-devtools";

// https://vite.dev/config/
export default defineConfig({
  plugins: [vue(), vueDevTools()],
  resolve: {
    // https://cn.vitejs.dev/config/#resolve-alias
    alias: {
      // 设置路径
      "~": path.resolve(__dirname, "./"),
      // 设置别名
      "@": path.resolve(__dirname, "./src"),
      // "@": path.resolve(__dirname, "./src"), // @指向src目录
      // "@components": path.resolve(__dirname, "./src/components"),
      // "@api": path.resolve(__dirname, "./src/api"), // 接口请求目录
    },
    // https://cn.vitejs.dev/config/#resolve-extensions
    extensions: [".mjs", ".js", ".ts", ".jsx", ".tsx", ".json", ".vue"],
  },
  server: {
    // 是否开启 https
    https: false,
    // 端口号
    port: 8080,
    host: "0.0.0.0",
    // 本地跨域代理 https://cn.vitejs.dev/config/server-options.html#server-proxy
    proxy: {
      "/cms": {
        target: "http://localhost:9002",
        // target: "http://192.168.19.248:9002",
        // target: "http://172.16.70.52:8081",
        // target: "http://192.168.19.142:9002",
        changeOrigin: true,
        // rewrite: (path) => path.replace(/^\/cms/, "/cms"),
      },
    },
    cors: true,
  },
  // resolve: {
  //   alias: {
  //     "@": fileURLToPath(new URL("./src", import.meta.url)),
  //   },
  // },
});
