/** @type {import('tailwindcss').Config} */
module.exports = {
  darkMode: "class",
  corePlugins: {
      preflight: false
  },
  content: ["./index.html", "./src/**/*.{vue,js,ts,jsx,tsx}"],
  theme: {
      extend: {
          colors: {
              bg_color: "var(--el-bg-color)",
              primary: "var(--el-color-primary)",
              text_color_primary: "var(--el-text-color-primary)",
              text_color_regular: "var(--el-text-color-regular)",
              text_color_000: '#000',
              text_color_333: '#333',
              text_color_666: '#666',
              text_color_999: '#999'
          }
      },
      // 自定义字体(思源)
      fontFamily: {
          'SourceHanSansCN-Bold': "var(--font-bold)",
          'SourceHanSansCN-Medium': "var(--font-medium)",
          'SourceHanSansCN-Light': "var(--font-light)",
          'SourceHanSansCN-Normal': "var(--font-normal)",
          'SourceHanSansCN-Heavy': "var(--font-heavy)",
          'SourceHanSansCN-Regular': "var(--font-regular)",
          'SourceHanSansCN-Extra-light': "var(--font-extra-light)",
      }
  }
};
