import { fileURLToPath, URL } from "node:url";

import { defineConfig } from "vite";
import vue from "@vitejs/plugin-vue";
import path from "path";
import vueDevTools from "vite-plugin-vue-devtools";
import legacy from "@vitejs/plugin-legacy";

// https://vite.dev/config/
export default defineConfig({
  plugins: [
    vue(),
    vueDevTools(),
    legacy({
      targets: ["chrome 50"], // 明确兼容 Chrome 50
      additionalLegacyPolyfills: ["core-js/features/object/entries"], // 按需补充 polyfill
      renderLegacyChunks: true, // 生成旧浏览器专用代码块
      polyfills: [
        "es.symbol",
        "es.array.filter",
        "es.object.get-own-property-descriptor",
        "es.array.flat-map",
        "es.array.flat",
      ],
    }),
  ],
  resolve: {
    // https://cn.vitejs.dev/config/#resolve-alias
    alias: {
      // 设置路径
      "~": path.resolve(__dirname, "./"),
      // 设置别名
      "@": path.resolve(__dirname, "./src"),
      // "@": path.resolve(__dirname, "./src"), // @指向src目录
      // "@components": path.resolve(__dirname, "./src/components"),
      // "@api": path.resolve(__dirname, "./src/api"), // 接口请求目录
    },
    // https://cn.vitejs.dev/config/#resolve-extensions
    extensions: [".mjs", ".js", ".ts", ".jsx", ".tsx", ".json", ".vue"],
  },
  server: {
    // 是否开启 https
    https: false,
    // 端口号
    port: 8081,
    host: "0.0.0.0",
    // 本地跨域代理 https://cn.vitejs.dev/config/server-options.html#server-proxy
    proxy: {
      "/cms": {
        target: "http://localhost:9002",
        // target: "http://192.168.19.248:9002",
        // target: "http://172.16.70.52:8081",
        // target: "http://192.168.19.142:9002",
        changeOrigin: true,
        // rewrite: (path) => path.replace(/^\/cms/, "/cms"),
      },
    },
    cors: true,
  },
});
