import { createRouter, createWebHashHistory } from "vue-router";

// 首页新闻
import NewsLayout from "../layout/news.vue";
import HomeView from "../views/home/home/HomeView.vue";
import News from "../views/home/hotnews/News.vue";
import TaiyuanNews from "../views/home/tynews/TaiyuanNews.vue";
import ShanxiNews from "../views/home/sxnews/ShanxiNews.vue";
import Announcements from "../views/home/announcements/Announcements.vue";
import Jb from "../views/home/jb/Jb.vue";
import NewsDetail from "../views/home/detail/NewsDetail.vue";
import SearchList from "../views/home/search/SearchList.vue";

//辟谣
import PyLayout from "../layout/py.vue";
import PyHome from "../views/py/home/PyHome.vue";
import Authority from "../views/py/authority/Authority.vue";
import Rumor from "../views/py/rumor/Rumor.vue";
import Expert from "../views/py/expert/Expert.vue";
import Law from "../views/py/law/Law.vue";
import Reading from "../views/py/reading/Reading.vue";
import PyNewsDetail from "../views/py/detail/NewsDetail.vue";
import SearchPYList from "../views/py/search/SearchList.vue";

//网名有话说
import WmLayout from "../layout/wm.vue";
import WmHome from "../views/wm/home/WmHome.vue";
import MessageList from "../views/wm/message/MessageList.vue";
import RecoverList from "../views/wm/recover/RecoverList.vue";
import MessageDetail from "../views/wm/message/MessageDetail.vue";
import RecoverDetail from "../views/wm/recover/RecoverDetail.vue";
import IMessage from "../views/wm/imessage/IMessage.vue";
import WmSearchList from "../views/wm/search/WmSearchList.vue";

// 举报平台布局
// import JbLayout from "../layout/jb.vue";
import TyJb from "../views/jb/tyjb/TyJb.vue"; //太原市举报平台
import TySubmit from "../views/jb/submit/TySubmit.vue"; //太原市举报平台提交

const router = createRouter({
  history: createWebHashHistory(import.meta.env.BASE_URL),
  routes: [
    {
      path: "/",
      name: "home",
      redirect: "/home/home",
      component: NewsLayout,
      children: [
        {
          name: "Home",
          path: "/home/home",
          component: HomeView,
        },
        {
          name: "News",
          path: "/home/news",
          component: News,
        },
        {
          name: "TyNews",
          path: "/home/tynews",
          component: TaiyuanNews,
        },
        {
          name: "SxNews",
          path: "/home/sxnews",
          component: ShanxiNews,
        },
        {
          name: "Announcements",
          path: "/home/announcements",
          component: Announcements,
        },
        {
          name: "Jb",
          path: "/home/jb",
          component: Jb,
        },
        {
          name: "NewsDetail",
          path: "/home/news/detail",
          component: NewsDetail,
        },
        {
          name: "SearchList",
          path: "/home/search",
          component: SearchList,
        },
      ],
    },
    {
      path: "/py",
      name: "/py/home",
      component: PyLayout,
      children: [
        {
          name: "PyHome",
          path: "/py/pyhome",
          component: PyHome,
        },
        {
          name: "PyAuthority",
          path: "/py/authority",
          component: Authority,
        },
        {
          name: "PyRumor",
          path: "/py/rumor",
          component: Rumor,
        },
        {
          name: "PyExpert",
          path: "/py/expert",
          component: Expert,
        },
        {
          name: "PyLaw",
          path: "/py/law",
          component: Law,
        },
        {
          name: "PyReading",
          path: "/py/reading",
          component: Reading,
        },
        {
          name: "PyNewsDetail",
          path: "/py/news/detail",
          component: PyNewsDetail,
        },
        {
          name: "SearchPYList",
          path: "/py/search",
          component: SearchPYList,
        },
      ],
    },

    {
      path: "/wm",
      name: "wm",
      component: WmLayout,
      children: [
        {
          name: "WmHome",
          path: "/wm/wmhome",
          component: WmHome,
        },
        {
          name: "MessageList",
          path: "/wm/messagelist",
          component: MessageList,
        },
        {
          name: "RecoverList",
          path: "/wm/recoverlist",
          component: RecoverList,
        },
        {
          name: "MessageDetail",
          path: "/wm/messagedetail",
          component: MessageDetail,
        },
        {
          name: "RecoverDetail",
          path: "/wm/recoverdetail",
          component: RecoverDetail,
        },
        {
          name: "IMessage",
          path: "/wm/imessage",
          component: IMessage,
        },
        {
          name: "WmSearchList",
          path: "/wm/search",
          component: WmSearchList,
        },
      ],
    },
    {
      path: "/jb/tyjb",
      name: "jb",
      component: TyJb,
    },
    {
      path: "/jb/tysubmit",
      name: "tysubmit",
      component: TySubmit,
    },
  ],
});

export default router;
