import {
	baseUrl
} from "../config.js";
// import {
// 	getToken
// } from '@/utils/auth'; // 导入获取 token 的函数  

// 上传图片的异步函数  
const uploadImg = async function(tempFilePaths) {
	const baseUrls = baseUrl; // 基础 URL 从配置中获取  
	// const token = getToken(); // 使用 getToken 函数获取 token  
	const successfulUploads = []; // 数组用于记录所有成功上传的文件路径  
	if (!tempFilePaths.length) return []; // 如果没有选择图片就退出，返回空数组  
	// 遍历选择的图片路径  
	for (const path of tempFilePaths) {
		try {
			// 调用接口上传每一个文件  
			const [err, {
				data
			}] = await uni.uploadFile({
				url: `${baseUrls}/common/upload`, // 自己的后台地址  
				filePath: path,
				name: 'file',
				// header: { // 添加请求头  
				// 	'Authorization': `Bearer ${token}`, // 假设你使用的是 Bearer 认证  
				// 	// 可以添加其他需要的请求头  
				// },
			});

			// 处理错误情况  
			if (err) {
				console.error('上传错误:', err);
				continue; // 如果上传出错，继续上传下一张图片  
			}
			// 把返回的数据转为对象格式  
			const res = JSON.parse(data);
			console.log(res)
			// 将每个上传成功的文件路径添加到数组中  
			successfulUploads.push(res); // 假设 res.data 是上传后的文件路径  
		} catch (error) {
			console.error('处理上传时发生错误:', error);
			continue; // 捕获上传错误并继续  
		}
	}
	// 返回所有成功上传的文件路径  
	return successfulUploads;
};

// 导出 uploadImg 函数  
export default uploadImg;