// 引入 request 文件
import request from '@/network/request.js'
  
// 新闻列表
export function getNewsList(params) {
	return request({
		url: "/cms/content/list",
		method: "get",
		data: params,
	});
}

// 新闻点击数量
export function getHit(contentId) {
	return request({
		url: "/cms/content/" + contentId + "/hit",
		data: "get",
	});
}

//新闻详情
export function getNewsDetail(params) {
  return request({
    url: "/cms/content/get",
    method: "get",
    data: params,
  });
}

export function getTab(categoryFlag) {
  return request({
    url: "/cms/category/list?categoryFlag="+categoryFlag,
    method: "post",
    // data: params, 
  });
}


// // 获取学习列表详细信息
// export const studyInfoById = (id) => {
// 	return request({
// 		url: `/study/studyInfo/${id}`,
// 		method: 'get',
// 	})
// }